/*
 * Decompiled with CFR 0.152.
 */
package gelf4j.log4j;

import gelf4j.GelfConnection;
import gelf4j.GelfMessage;
import gelf4j.GelfMessageUtil;
import gelf4j.GelfTargetConfig;
import gelf4j.SyslogLevel;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class GelfAppender
extends AppenderSkeleton {
    private static final String FIELD_LOGGER_NDC = "loggerNdc";
    private static boolean c_searchForMethodOccurred;
    private static Method c_getTimestampMethod;
    private final GelfTargetConfig _config = new GelfTargetConfig();
    private GelfConnection _connection;

    public final GelfTargetConfig getConfig() {
        return this._config;
    }

    public void setCompressedChunking(boolean compressedChunking) {
        this._config.setCompressedChunking(compressedChunking);
    }

    public void setPort(int port) {
        this._config.setPort(port);
    }

    public void setHost(String host) {
        this._config.setHost(host);
    }

    public void setCodecClass(String codecClass) {
        this._config.setCodecClass(codecClass);
    }

    public void setAdditionalFields(String additionalFields) {
        this._config.setAdditionalFields(additionalFields);
    }

    public void setDefaultFields(String data) {
        this._config.setDefaultFields(data);
    }

    @Override
    public void activateOptions() {
        try {
            this._connection = this._config.createConnection();
        }
        catch (Exception e) {
            this.errorHandler.error("Error initialising gelf connection", e, 1);
        }
    }

    public void close() {
        if (null != this._connection) {
            try {
                this._connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._connection = null;
        }
    }

    protected void append(LoggingEvent event) {
        if (this._connection == null || !this._connection.send(this.makeMessage(event))) {
            this.errorHandler.error("Could not send GELF message");
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    private GelfMessage makeMessage(LoggingEvent event) {
        long timestamp = this.getTimestamp(event);
        LocationInfo locationInformation = event.getLocationInformation();
        String file = locationInformation.getFileName();
        Integer lineNumber = null;
        try {
            String lineInfo = locationInformation.getLineNumber();
            if (null != lineInfo) {
                lineNumber = Integer.parseInt(lineInfo);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String renderedMessage = event.getRenderedMessage();
        SyslogLevel level = SyslogLevel.values()[event.getLevel().getSyslogEquivalent()];
        GelfMessage message = this._connection.newMessage(level, renderedMessage == null ? "" : renderedMessage, timestamp);
        if (null != lineNumber) {
            message.setLine(lineNumber.intValue());
        }
        if (null != file) {
            message.setFile(file);
        }
        for (Map.Entry<String, String> entry : this._config.getAdditionalFields().entrySet()) {
            String fieldName = entry.getValue();
            String key = entry.getKey();
            if ("loggerName".equals(fieldName)) {
                GelfMessageUtil.setValue(message, key, event.getLoggerName());
                continue;
            }
            if ("threadName".equals(fieldName)) {
                GelfMessageUtil.setValue(message, key, event.getThreadName());
                continue;
            }
            if ("timestampMs".equals(fieldName)) {
                GelfMessageUtil.setValue(message, key, message.getJavaTimestamp());
                continue;
            }
            if ("exception".equals(fieldName)) {
                ThrowableInformation throwable = event.getThrowableInformation();
                if (null == throwable) continue;
                GelfMessageUtil.setValue(message, key, GelfMessageUtil.extractStacktrace(throwable.getThrowable()));
                continue;
            }
            if (FIELD_LOGGER_NDC.equals(fieldName)) {
                String ndc = event.getNDC();
                if (null == ndc) continue;
                GelfMessageUtil.setValue(message, key, ndc);
                continue;
            }
            Object value = event.getMDC(key);
            if (null != value) {
                GelfMessageUtil.setValue(message, key, value);
                continue;
            }
            Object valueByFieldName = event.getMDC(fieldName);
            if (null == valueByFieldName) continue;
            GelfMessageUtil.setValue(message, key, valueByFieldName);
        }
        message.getAdditionalFields().putAll(this._config.getDefaultFields());
        return message;
    }

    private long getTimestamp(LoggingEvent event) {
        if (!c_searchForMethodOccurred) {
            for (Method method : event.getClass().getDeclaredMethods()) {
                if (!method.getName().equals("getTimeStamp")) continue;
                c_getTimestampMethod = method;
                c_searchForMethodOccurred = true;
            }
        }
        if (null != c_getTimestampMethod) {
            try {
                return (Long)c_getTimestampMethod.invoke((Object)event, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return System.currentTimeMillis();
    }
}

