/*
 * Decompiled with CFR 0.152.
 */
package gelf4j.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.AppenderBase;
import gelf4j.GelfConnection;
import gelf4j.GelfMessage;
import gelf4j.GelfMessageUtil;
import gelf4j.GelfTargetConfig;
import gelf4j.SyslogLevel;
import java.io.IOException;
import java.util.Map;

public class GelfAppender<E>
extends AppenderBase<E> {
    private final GelfTargetConfig _config = new GelfTargetConfig();
    private GelfConnection _connection;

    public GelfTargetConfig getConfig() {
        return this._config;
    }

    public void setCompressedChunking(boolean compressedChunking) {
        this._config.setCompressedChunking(compressedChunking);
    }

    public void setPort(int port) {
        this._config.setPort(port);
    }

    public void setHost(String host) {
        this._config.setHost(host);
    }

    public void setCodecClass(String codecClass) {
        this._config.setCodecClass(codecClass);
    }

    public void setAdditionalFields(String additionalFields) {
        this._config.setAdditionalFields(additionalFields);
    }

    public void setDefaultFields(String data) {
        this._config.setDefaultFields(data);
    }

    @Override
    public void start() {
        super.start();
        try {
            this._connection = this._config.createConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initialising gelf connection", e);
        }
    }

    @Override
    public void stop() {
        if (null != this._connection) {
            try {
                this._connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._connection = null;
        }
        super.stop();
    }

    @Override
    protected void append(E logEvent) {
        try {
            this._connection.send(this.toGelf(logEvent));
        }
        catch (RuntimeException e) {
            this.addError("Error occurred: ", e);
            throw e;
        }
    }

    private GelfMessage toGelf(E logEvent) {
        ILoggingEvent event = (ILoggingEvent)logEvent;
        String formattedMessage = event.getFormattedMessage();
        SyslogLevel level = SyslogLevel.values()[LevelToSyslogSeverity.convert(event)];
        GelfMessage message = this._connection.newMessage(level, formattedMessage, event.getTimeStamp());
        Map<String, String> mdc = event.getMDCPropertyMap();
        for (Map.Entry<String, String> entry : this._config.getAdditionalFields().entrySet()) {
            String fieldName = entry.getValue();
            String key = entry.getKey();
            if ("loggerName".equals(fieldName)) {
                GelfMessageUtil.setValue(message, key, event.getLoggerName());
                continue;
            }
            if ("threadName".equals(fieldName)) {
                GelfMessageUtil.setValue(message, key, event.getThreadName());
                continue;
            }
            if ("timestampMs".equals(fieldName)) {
                GelfMessageUtil.setValue(message, key, message.getJavaTimestamp());
                continue;
            }
            if ("exception".equals(fieldName)) {
                IThrowableProxy proxy = event.getThrowableProxy();
                if (null == proxy) continue;
                StringBuilder sb = new StringBuilder();
                this.collectExceptionMessage(proxy, sb);
                GelfMessageUtil.setValue(message, key, sb.toString());
                continue;
            }
            if (null == mdc) continue;
            String value = mdc.get(key);
            if (null != value) {
                GelfMessageUtil.setValue(message, key, value);
                continue;
            }
            String valueByFieldName = mdc.get(fieldName);
            if (null == valueByFieldName) continue;
            GelfMessageUtil.setValue(message, key, valueByFieldName);
        }
        message.getAdditionalFields().putAll(this._config.getDefaultFields());
        return message;
    }

    private void collectExceptionMessage(IThrowableProxy proxy, StringBuilder sb) {
        sb.append(proxy.getClassName());
        String m = proxy.getMessage();
        if (null != m) {
            sb.append(": ");
            sb.append(m);
        }
        sb.append("\n");
        for (StackTraceElementProxy element : proxy.getStackTraceElementProxyArray()) {
            sb.append("\t");
            sb.append(element.getSTEAsString());
            sb.append("\n");
        }
        IThrowableProxy cause = proxy.getCause();
        if (null != cause) {
            sb.append("Caused by: ");
            this.collectExceptionMessage(cause, sb);
        }
    }

    private String toStackTraceString(StackTraceElementProxy[] elements) {
        StringBuilder str = new StringBuilder();
        for (StackTraceElementProxy element : elements) {
            str.append(element.getSTEAsString());
        }
        return str.toString();
    }
}

