/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.booty;

import java.util.List;
import org.irenical.booty.BootyConfig;
import org.irenical.booty.InvalidConfigurationException;
import org.irenical.lifecycle.LifeCycle;
import org.irenical.lifecycle.builder.CompositeLifeCycle;
import org.slf4j.LoggerFactory;

public class Booty
extends CompositeLifeCycle {
    private BootyConfig config;

    private Booty() {
    }

    public static LifeCycle build(BootyConfig bootyConfig) {
        Booty.assertConfig(bootyConfig);
        List<LifeCycle> lifecycles = bootyConfig.getLifecycleSupplier().get();
        if (lifecycles == null || lifecycles.isEmpty()) {
            throw new InvalidConfigurationException("No lifecycle was supplied");
        }
        Booty booty = new Booty();
        booty.config = bootyConfig;
        lifecycles.forEach(booty::append);
        if (bootyConfig.isShutdownHook()) {
            booty.withShutdownHook();
        }
        return booty;
    }

    @Override
    public synchronized <ERROR extends Exception> void start() throws ERROR {
        try {
            super.start();
        }
        catch (Exception e) {
            try {
                super.stop();
            }
            finally {
                this.config.getOnError().accept(e);
            }
        }
    }

    private static void assertConfig(BootyConfig got) {
        if (got == null) {
            throw new InvalidConfigurationException("BootyConfig cannot be null");
        }
        if (got.getLifecycleSupplier() == null) {
            throw new InvalidConfigurationException("Lifecycle supplier cannot be null");
        }
        if (got.getOnError() == null) {
            got.setOnError(e -> LoggerFactory.getLogger(Booty.class).error("Error bootstrapping application", (Throwable)e));
        }
    }
}

