/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.drowsy.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigFactory;
import org.irenical.lifecycle.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrowsyDataSource
implements LifeCycle,
DataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrowsyDataSource.class);
    private static String DATASOURCECLASSNAME = "dataSourceClassName";
    private static String JDBCURL = "jdbcUrl";
    private static String USERNAME = "username";
    private static String PASSWORD = "password";
    private static String AUTOCOMMIT = "autoCommit";
    private static String CONNECTIONTIMEOUT = "connectionTimeout";
    private static String IDLETIMEOUT = "idleTimeout";
    private static String MAXLIFETIME = "maxLifetime";
    private static String CONNECTIONTESTQUERY = "connectionTestQuery";
    private static String MINIMUMIDLE = "minimumIdle";
    private static String MAXIMUMPOOLSIZE = "maximumPoolSize";
    private static String POOLNAME = "poolName";
    private static String INITIALIZATIONFAILFAST = "initializationFailFast";
    private static String ISOLATEINTERNALQUERIES = "isolateInternalQueries";
    private static String ALLOWPOOLSUSPENSION = "allowPoolSuspension";
    private static String READONLY = "readOnly";
    private static String REGISTERMBEANS = "registerMbeans";
    private static String CATALOG = "catalog";
    private static String CONNECTIONINITSQL = "connectionInitSql";
    private static String DRIVERCLASSNAME = "driverClassName";
    private static String TRANSACTIONISOLATION = "transactionIsolation";
    private static String VALIDATIONTIMEOUT = "validationTimeout";
    private static String LEAKDETECTIONTHRESHOLD = "leakDetectionThreshold";
    private static String FLYWAY_BYPASS = "flyway.bypass";
    private static String FLYWAY_BASELINE_VERSION = "flyway.baselineVersion";
    private final Config config;
    private HikariDataSource dataSource;

    public DrowsyDataSource() {
        this(ConfigFactory.getConfig().filterPrefix("jdbc"));
    }

    public DrowsyDataSource(Config config) {
        this.config = config;
    }

    @Override
    public void start() {
        this.initDataSource();
        this.setupConfigListeners();
    }

    @Override
    public void stop() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        boolean isClosed = this.dataSource.isClosed();
        if (isClosed) {
            return false;
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOGGER.error(e.getLocalizedMessage(), e);
                }
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.dataSource.getConnection(username, password);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    private HikariDataSource createDataSource() {
        HikariConfig hikariConfig = this.jindyToHikari();
        return new HikariDataSource(hikariConfig);
    }

    private HikariConfig jindyToHikari() {
        HikariConfig result = new HikariConfig();
        result.setDataSourceClassName(this.config.getString(DATASOURCECLASSNAME));
        result.setJdbcUrl(this.config.getString(JDBCURL));
        result.setUsername(this.config.getString(USERNAME));
        result.setPassword(this.config.getString(PASSWORD));
        result.setConnectionTimeout(this.config.getInt(CONNECTIONTIMEOUT, 30000));
        result.setIdleTimeout(this.config.getInt(IDLETIMEOUT, 600000));
        result.setMaxLifetime(this.config.getInt(MAXLIFETIME, 1800000));
        result.setConnectionTestQuery(this.config.getString(CONNECTIONTESTQUERY));
        result.setMinimumIdle(this.config.getInt(MINIMUMIDLE, 1));
        result.setMaximumPoolSize(this.config.getInt(MAXIMUMPOOLSIZE, 10));
        result.setPoolName(this.config.getString(POOLNAME));
        result.setInitializationFailFast(this.config.getBoolean(INITIALIZATIONFAILFAST, true));
        result.setIsolateInternalQueries(this.config.getBoolean(ISOLATEINTERNALQUERIES, false));
        result.setAllowPoolSuspension(this.config.getBoolean(ALLOWPOOLSUSPENSION, false));
        result.setRegisterMbeans(this.config.getBoolean(REGISTERMBEANS, false));
        result.setCatalog(this.config.getString(CATALOG));
        result.setConnectionInitSql(this.config.getString(CONNECTIONINITSQL));
        String driverClassName = this.config.getString(DRIVERCLASSNAME);
        if (driverClassName != null) {
            result.setDriverClassName(driverClassName);
        }
        result.setTransactionIsolation(this.config.getString(TRANSACTIONISOLATION));
        result.setValidationTimeout(this.config.getInt(VALIDATIONTIMEOUT, 5000));
        result.setLeakDetectionThreshold(this.config.getInt(LEAKDETECTIONTHRESHOLD, 0));
        result.setAutoCommit(this.isAutoCommit());
        result.setReadOnly(this.isReadOnly());
        return result;
    }

    private void initDataSource() {
        this.dataSource = this.createDataSource();
        this.migrate();
    }

    private void migrate() {
        if (this.isFlywayBypass()) {
            return;
        }
        Flyway flyway = new Flyway();
        flyway.setDataSource(this.dataSource);
        String baseline = this.config.getString(FLYWAY_BASELINE_VERSION);
        flyway.setBaselineOnMigrate(true);
        if (baseline != null) {
            flyway.setBaselineVersionAsString(baseline);
        }
        flyway.migrate();
    }

    private void setupConfigListeners() {
        Arrays.asList(DATASOURCECLASSNAME, JDBCURL, USERNAME, PASSWORD, AUTOCOMMIT, CONNECTIONTIMEOUT, POOLNAME, CONNECTIONTESTQUERY, INITIALIZATIONFAILFAST, ISOLATEINTERNALQUERIES, ALLOWPOOLSUSPENSION, READONLY, REGISTERMBEANS, CATALOG, CONNECTIONINITSQL, DRIVERCLASSNAME, TRANSACTIONISOLATION, LEAKDETECTIONTHRESHOLD, FLYWAY_BYPASS, FLYWAY_BASELINE_VERSION).stream().forEach(p -> this.config.listen((String)p, this::onConnectionPropertyChanged));
        this.config.listen(MAXIMUMPOOLSIZE, () -> this.dataSource.setMaximumPoolSize(this.config.getInt(MAXIMUMPOOLSIZE, 10)));
        this.config.listen(MINIMUMIDLE, () -> this.dataSource.setMinimumIdle(this.config.getInt(MINIMUMIDLE, 1)));
        this.config.listen(IDLETIMEOUT, () -> this.dataSource.setIdleTimeout(this.config.getInt(IDLETIMEOUT, 600000)));
        this.config.listen(MAXLIFETIME, () -> this.dataSource.setMaxLifetime(this.config.getInt(MAXLIFETIME, 1800000)));
        this.config.listen(VALIDATIONTIMEOUT, () -> this.dataSource.setValidationTimeout(this.config.getInt(VALIDATIONTIMEOUT, 5000)));
    }

    private void onConnectionPropertyChanged() {
        block2: {
            LOGGER.info("DataSource Configuration changed. Creating new datasource...");
            try {
                HikariDataSource oldDataSource = this.dataSource;
                this.initDataSource();
                oldDataSource.close();
            }
            catch (HikariPool.PoolInitializationException e) {
                LOGGER.error("Error initializing backend", e);
                if (this.dataSource == null || this.dataSource.isClosed()) break block2;
                this.dataSource.close();
            }
        }
    }

    protected boolean isAutoCommit() {
        return this.config.getBoolean(AUTOCOMMIT, false);
    }

    protected boolean isReadOnly() {
        return this.config.getBoolean(READONLY, false);
    }

    protected boolean isFlywayBypass() {
        return this.config.getBoolean(FLYWAY_BYPASS, false);
    }
}

