/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.drowsy.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.irenical.drowsy.transaction.DrowsyConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcTransaction<OUTPUT> {
    private final Logger LOG = LoggerFactory.getLogger(JdbcTransaction.class);
    private final boolean assumeAutoCommit;

    public JdbcTransaction() {
        this(false);
    }

    public JdbcTransaction(boolean assumeAutoCommit) {
        this.assumeAutoCommit = assumeAutoCommit;
    }

    protected abstract OUTPUT execute(Connection var1) throws SQLException;

    public OUTPUT run(DataSource dataSource) throws SQLException {
        if (dataSource == null) {
            throw new IllegalArgumentException("JDBC datasource cannot be null");
        }
        return this.run(dataSource.getConnection());
    }

    public OUTPUT run(Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("JDBC connection cannot be null");
        }
        connection = DrowsyConnection.wrap(connection);
        try {
            OUTPUT result = this.execute(connection);
            if (!this.assumeAutoCommit) {
                connection.commit();
            }
            OUTPUT OUTPUT = result;
            return OUTPUT;
        }
        catch (SQLException e) {
            if (!this.assumeAutoCommit) {
                this.LOG.error("Error executing transaction. Raising exception after trying to rollback.");
                try {
                    connection.rollback();
                }
                catch (SQLException rollbackException) {
                    this.LOG.error("Error rollbacking transaction. Cause: " + rollbackException.getMessage());
                }
            }
            throw e;
        }
        finally {
            connection.close();
        }
    }
}

