/*
 * Decompiled with CFR 0.152.
 */
package gelf4j;

import gelf4j.GelfEncoder;
import gelf4j.GelfMessage;
import gelf4j.GelfMessageUtil;
import gelf4j.GelfTargetConfig;
import gelf4j.SyslogLevel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.List;
import java.util.Map;

public class GelfConnection {
    private final GelfTargetConfig _config;
    private final GelfEncoder _encoder;
    private DatagramChannel _channel;

    protected GelfConnection(GelfTargetConfig config) throws Exception {
        this._config = config;
        this._encoder = new GelfEncoder(GelfMessageUtil.getLocalHost(), this._config.isCompressedChunking(), this._config.getCodec());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (null != this._channel) {
            try {
                this._channel.close();
            }
            finally {
                this._channel = null;
            }
        }
    }

    public GelfMessage newMessage(SyslogLevel level, String message, long timestamp) {
        GelfMessage gelfMessage = this.newMessage();
        gelfMessage.setJavaTimestamp(timestamp);
        gelfMessage.setLevel(level);
        gelfMessage.setFullMessage(message);
        gelfMessage.setShortMessage(GelfMessageUtil.truncateShortMessage(message));
        return gelfMessage;
    }

    public GelfMessage newMessage() {
        GelfMessage gelfMessage = new GelfMessage();
        for (Map.Entry<String, Object> entry : this._config.getDefaultFields().entrySet()) {
            GelfMessageUtil.setValue(gelfMessage, entry.getKey(), entry.getValue());
        }
        return gelfMessage;
    }

    public boolean send(GelfMessage message) {
        List<byte[]> packets = this._encoder.encode(message);
        return null != packets && this.send(packets);
    }

    private boolean send(List<byte[]> packets) {
        for (byte[] packet : packets) {
            if (this.sendPacket(packet)) continue;
            return false;
        }
        return true;
    }

    private boolean sendPacket(byte[] packet) {
        ByteBuffer buffer = ByteBuffer.allocate(packet.length);
        buffer.put(packet);
        buffer.flip();
        return this.doSend(buffer);
    }

    private synchronized boolean doSend(ByteBuffer buffer) {
        try {
            this.getChannel().write(buffer);
            return true;
        }
        catch (IOException ioe) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }

    private synchronized DatagramChannel getChannel() throws IOException {
        if (null == this._channel) {
            this._channel = DatagramChannel.open();
            this._channel.socket().bind(new InetSocketAddress(0));
            this._channel.connect(new InetSocketAddress(this._config.getHostAddress(), this._config.getPort()));
            this._channel.configureBlocking(false);
        }
        return this._channel;
    }
}

