/*
 * Decompiled with CFR 0.152.
 */
package gelf4j;

import gelf4j.GelfMessage;
import gelf4j.SyslogLevel;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;

public final class GelfMessageUtil {
    static final int MAX_SHORT_MESSAGE_LENGTH = 250;
    private static final Map<String, DateFormat> c_formats = new WeakHashMap<String, DateFormat>();

    private GelfMessageUtil() {
    }

    public static String extractStacktrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    static SyslogLevel parseLevel(String level) {
        try {
            return SyslogLevel.values()[Integer.parseInt(level)];
        }
        catch (Exception e) {
            try {
                return SyslogLevel.valueOf(level);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long parseTimestamp(String format, String time) {
        try {
            DateFormat dateFormat;
            DateFormat dateFormat2 = dateFormat = GelfMessageUtil.getDateFormat(format);
            synchronized (dateFormat2) {
                return dateFormat.parse(time).getTime();
            }
        }
        catch (Exception e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateFormat getDateFormat(String format) {
        Map<String, DateFormat> map = c_formats;
        synchronized (map) {
            DateFormat dateFormat = c_formats.get(format);
            if (null == dateFormat) {
                dateFormat = new SimpleDateFormat(format);
                c_formats.put(format, dateFormat);
            }
            return dateFormat;
        }
    }

    public static void setValue(GelfMessage message, String key, Object value) {
        if (key.equals("level")) {
            SyslogLevel level = GelfMessageUtil.parseLevel(String.valueOf(value));
            message.setLevel(null != level ? level : SyslogLevel.INFO);
        } else if (key.equals("facility")) {
            message.setFacility(String.valueOf(value));
        } else if (key.startsWith("timestamp:")) {
            String format = key.substring("timestamp:".length());
            long timestamp = GelfMessageUtil.parseTimestamp(format, String.valueOf(value));
            if (0L != timestamp) {
                message.setJavaTimestamp(timestamp);
            }
        } else if (key.equals("line")) {
            try {
                message.setLine(Integer.parseInt(String.valueOf(value)));
            }
            catch (NumberFormatException nfe) {}
        } else if (key.equals("file")) {
            message.setFile(String.valueOf(value));
        } else if (key.equals("host")) {
            message.setHost(String.valueOf(value));
        } else if (key.equals("message")) {
            String textMessage = String.valueOf(value);
            message.setShortMessage(GelfMessageUtil.truncateShortMessage(textMessage));
            message.setFullMessage(textMessage);
        } else {
            message.getAdditionalFields().put(key, value);
        }
    }

    public static String truncateShortMessage(String message) {
        if (null == message) {
            return "";
        }
        if (message.length() > 250) {
            return message.substring(0, 250);
        }
        return message;
    }

    static String getLocalHost() throws IOException {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                Enumeration<InetAddress> addresses;
                NetworkInterface networkInterface = interfaces.nextElement();
                if (null == networkInterface || !(addresses = networkInterface.getInetAddresses()).hasMoreElements()) continue;
                return addresses.nextElement().getHostAddress();
            }
            throw uhe;
        }
    }
}

