/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.lifecycle.builder;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.irenical.lifecycle.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeLifeCycle
implements LifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeLifeCycle.class);
    private final List<LifeCycle> children = new CopyOnWriteArrayList<LifeCycle>();
    private final Thread terminator = new Thread(this::stop, "Composite LifeCycle shutdown hook");
    private boolean started = false;

    public synchronized CompositeLifeCycle append(LifeCycle child) {
        if (child == null) {
            throw new IllegalArgumentException("You cannot append a null LifeCycle");
        }
        if (this.started) {
            throw new IllegalStateException("Composite Lifecycle already started");
        }
        this.children.add(child);
        return this;
    }

    public synchronized void withShutdownHook() {
        Runtime.getRuntime().addShutdownHook(this.terminator);
    }

    @Override
    public synchronized void stop() {
        LOG.info("Stopping Composite LifeCycle");
        for (int i = this.children.size(); i > 0; --i) {
            LifeCycle hatchling = null;
            try {
                hatchling = this.children.get(i - 1);
                LOG.info("Stopping LifeCycle '" + hatchling + "'");
                hatchling.stop();
                LOG.info("LifeCycle '" + hatchling + "' was successfully stopped");
                continue;
            }
            catch (Exception e) {
                LOG.error("Error stoping LifeCycle: " + hatchling + "... ignoring", e);
            }
        }
        this.children.clear();
    }

    @Override
    public synchronized <ERROR extends Exception> boolean isRunning() throws ERROR {
        return this.children.stream().allMatch(LifeCycle::isRunning) && !this.children.isEmpty();
    }

    @Override
    public synchronized <ERROR extends Exception> void start() throws ERROR {
        LOG.info("Starting Composite LifeCycle");
        if (this.started) {
            throw new IllegalStateException("Composite Lifecycle already started");
        }
        this.children.stream().forEach(LifeCycle::start);
        this.started = true;
    }
}

