/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.slf4j;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import gelf4j.logback.GelfAppender;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigContext;
import org.irenical.jindy.ConfigFactory;
import org.irenical.slf4j.LoggerConfigurator;

public class GelfLoggerConfigurator
extends LoggerConfigurator
implements Configurator {
    private static final String APPENDER_GELF = "GELF";
    private static final String GELF_ENABLED = "log.gelf.enabled";
    private static final String GELF_HOST = "log.gelf.host";
    private static final String GELF_PORT = "log.gelf.port";
    private final Config CONFIG = ConfigFactory.getConfig();

    @Override
    protected void initListeners() {
        super.initListeners();
        this.CONFIG.listen(GELF_ENABLED, this::updateGelf);
        this.CONFIG.listen(GELF_HOST, this::updateGelf);
        this.CONFIG.listen(GELF_PORT, this::updateGelf);
    }

    @Override
    public void configure(LoggerContext loggerContext) {
        super.configure(loggerContext);
        this.updateGelf();
    }

    private void updateGelf() {
        try {
            LoggerContext loggerContext = (LoggerContext)this.getContext();
            Logger logbackLogger = loggerContext.getLogger("ROOT");
            GelfAppender<ILoggingEvent> gelfAppender = (GelfAppender<ILoggingEvent>)logbackLogger.getAppender(APPENDER_GELF);
            if (this.CONFIG.getBoolean(GELF_ENABLED, false)) {
                ConfigContext context = ConfigFactory.getContext();
                String env = context == null ? "n.a." : context.getEnvironment();
                String stack = context == null ? "n.a." : context.getStack();
                String datacenter = context == null ? "n.a." : context.getDatacenter();
                String applicationId = context == null ? "n.a." : context.getApplicationId();
                logbackLogger.detachAppender((Appender<ILoggingEvent>)gelfAppender);
                gelfAppender = new GelfAppender<ILoggingEvent>();
                gelfAppender.setHost(this.CONFIG.getMandatoryString(GELF_HOST));
                gelfAppender.setPort(this.CONFIG.getMandatoryInt(GELF_PORT));
                gelfAppender.setCompressedChunking(true);
                gelfAppender.setDefaultFields("{\"environment\": \"" + env + "\", \"cluster\": \"" + stack + "\", \"facility\": \"" + datacenter + "\", \"application\": \"" + applicationId + "\"}");
                gelfAppender.setAdditionalFields("{\"level\": \"level\", \"logger\": \"loggerName\", \"thread_name\": \"threadName\", \"exception\": \"exception\", \"time_stamp\": \"timestampMs\"}");
                gelfAppender.setName(APPENDER_GELF);
                gelfAppender.setContext(loggerContext);
                gelfAppender.start();
                logbackLogger.addAppender((Appender<ILoggingEvent>)gelfAppender);
            } else {
                logbackLogger.detachAppender((Appender<ILoggingEvent>)gelfAppender);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

