/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.dumpy.impl.job;

import java.util.List;
import org.irenical.dumpy.api.IJob;
import org.irenical.dumpy.api.IJobProcessor;
import org.irenical.dumpy.api.IStream;
import org.irenical.dumpy.api.IStreamProcessor;
import org.irenical.dumpy.impl.db.DumpyDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseJobProcessor
implements IJobProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseJobProcessor.class);
    private final IStreamProcessor streamProcessor;
    private boolean isRunning = false;
    protected final DumpyDB dumpyDB;

    public BaseJobProcessor(DumpyDB dumpyDB, IStreamProcessor streamProcessor) {
        this.dumpyDB = dumpyDB;
        this.streamProcessor = streamProcessor;
    }

    public <ERROR extends Exception> void start() throws ERROR {
        this.streamProcessor.start();
        this.isRunning = true;
    }

    public <ERROR extends Exception> void stop() throws ERROR {
        this.isRunning = false;
        this.streamProcessor.stop();
    }

    public <ERROR extends Exception> boolean isRunning() throws ERROR {
        return this.isRunning && this.dumpyDB.isRunning() && this.streamProcessor.isRunning();
    }

    @Override
    public void accept(IJob iJob) {
        if (iJob == null) {
            throw new IllegalArgumentException("no job provided");
        }
        List<IStream> streams = iJob.getStreams();
        if (streams == null || streams.isEmpty()) {
            throw new IllegalArgumentException("no streams provided");
        }
        block2: while (this.isRunning && !Thread.currentThread().isInterrupted()) {
            for (IStream iStream : streams) {
                this.onStreamStart(iJob, iStream);
                try {
                    this.streamProcessor.process(iJob, iStream);
                    this.onStreamEnd(iJob, iStream);
                }
                catch (Exception e) {
                    this.onStreamFail(iJob, iStream, e);
                    this.isRunning = false;
                    continue block2;
                }
            }
        }
        LOGGER.debug("[ job ] done.");
    }

    protected <ERROR extends Exception> void onStreamStart(IJob iJob, IStream iStream) throws ERROR {
    }

    protected <ERROR extends Exception> void onStreamEnd(IJob iJob, IStream iStream) throws ERROR {
    }

    protected <ERROR extends Exception> void onStreamFail(IJob iJob, IStream iStream, Exception e) throws ERROR {
        LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
    }
}

