/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.dumpy.impl.db;

import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import javax.sql.DataSource;
import org.irenical.drowsy.datasource.DrowsyDataSource;
import org.irenical.drowsy.query.BaseQuery;
import org.irenical.drowsy.query.Query;
import org.irenical.drowsy.query.builder.sql.InsertBuilder;
import org.irenical.drowsy.query.builder.sql.SelectBuilder;
import org.irenical.drowsy.query.builder.sql.UpdateBuilder;
import org.irenical.dumpy.impl.db.JdbcInsertOperation;
import org.irenical.dumpy.impl.db.JdbcSelectOperation;
import org.irenical.dumpy.impl.db.JdbcUpdateOperation;
import org.irenical.dumpy.impl.model.PaginatedResponse;
import org.irenical.jindy.ConfigFactory;
import org.irenical.lifecycle.LifeCycle;

public class DumpyDB
implements LifeCycle {
    private static final int LIMIT = 10;
    private final DrowsyDataSource dataSource = new DrowsyDataSource(ConfigFactory.getConfig().filterPrefix("dumpy.jdbc")){

        protected boolean isAutoCommit() {
            return true;
        }
    };

    public <ERROR extends Exception> void start() throws ERROR {
        this.dataSource.start();
    }

    public <ERROR extends Exception> void stop() throws ERROR {
        this.dataSource.stop();
    }

    public <ERROR extends Exception> boolean isRunning() throws ERROR {
        return this.dataSource.isRunning();
    }

    public String getCursor(String jobCode, String streamCode) throws SQLException {
        Query query = ((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)SelectBuilder.select((Object[])new Object[]{"cursor"}).from("dumpy_stream")).where("job_code")).eq(new Object[]{jobCode})).and("stream_code")).eq(new Object[]{streamCode})).build();
        return (String)new JdbcSelectOperation<String>(query, rs -> rs != null && rs.next() ? rs.getString(1) : null).run((DataSource)this.dataSource);
    }

    public boolean setCursor(String jobCode, String streamCode, String cursor) throws SQLException {
        Query query = ((UpdateBuilder)((UpdateBuilder)((UpdateBuilder)UpdateBuilder.update((String)"dumpy_stream").setParam("cursor", (Object)cursor).where("job_code").eq(new Object[]{jobCode})).and("stream_code")).eq(new Object[]{streamCode})).build();
        return (Boolean)new JdbcUpdateOperation(query).run((DataSource)this.dataSource);
    }

    public Integer getStreamId(String jobCode, String streamCode) throws SQLException {
        Query query = ((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)SelectBuilder.select((Object[])new Object[]{"id"}).from("dumpy_stream")).where("job_code")).eq(new Object[]{jobCode})).and("stream_code")).eq(new Object[]{streamCode})).build();
        return (Integer)new JdbcSelectOperation<Integer>(query, rs -> rs != null && rs.next() ? Integer.valueOf(rs.getInt(1)) : null).run((DataSource)this.dataSource);
    }

    public Integer newStream(String jobCode, String streamCode) throws SQLException {
        Query query = InsertBuilder.into((String)"dumpy_stream").columns(new Object[]{"job_code", "stream_code", "cursor"}).values(new Object[]{jobCode, streamCode, null}).build();
        return (Integer)new JdbcInsertOperation(query).run((DataSource)this.dataSource);
    }

    public Boolean upsertEntities(String jobCode, String streamCode, Object[] entityIds, ZonedDateTime lastErrorStamp, ZonedDateTime lastUpdatedStamp) throws SQLException {
        int idx;
        if (entityIds == null || entityIds.length == 0) {
            return false;
        }
        String querySQL = "WITH queryStreamId AS (      SELECT id FROM dumpy_stream WHERE job_code = ? AND stream_code = ? ) , entities( entityId ) AS ( VALUES ";
        for (idx = 0; idx < entityIds.length; ++idx) {
            querySQL = querySQL + "(?)" + (idx < entityIds.length - 1 ? "," : "");
        }
        querySQL = querySQL + "), upsert AS (      UPDATE dumpy_stream_entity          SET last_error_stamp=?, last_updated_stamp=?          WHERE stream_id = ( SELECT id FROM queryStreamId )              AND entity_id IN ( ";
        for (idx = 0; idx < entityIds.length; ++idx) {
            querySQL = querySQL + "?" + (idx < entityIds.length - 1 ? "," : "");
        }
        querySQL = querySQL + "           ) RETURNING * ) INSERT INTO dumpy_stream_entity ( stream_id, entity_id, last_error_stamp, last_updated_stamp )      SELECT queryStreamId.id, entities.entityId, ?, ? FROM queryStreamId, entities WHERE NOT EXISTS ( SELECT * FROM upsert )";
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(jobCode);
        parameters.add(streamCode);
        Collections.addAll(parameters, entityIds);
        parameters.add(lastErrorStamp);
        parameters.add(lastUpdatedStamp);
        Collections.addAll(parameters, entityIds);
        parameters.add(lastErrorStamp);
        parameters.add(lastUpdatedStamp);
        BaseQuery query = new BaseQuery();
        query.setType(Query.TYPE.UPDATE);
        query.setQuery(querySQL);
        query.setParameters(parameters);
        return (Boolean)new JdbcUpdateOperation((Query)query).run((DataSource)this.dataSource);
    }

    public PaginatedResponse<String> get(String jobCode, String streamCode, String cursor) throws SQLException {
        Integer offset = cursor == null || cursor.trim().isEmpty() ? 0 : Integer.valueOf(cursor);
        Query query = ((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)SelectBuilder.select((Object[])new Object[]{"dumpy_stream_entity.entity_id"}).from("dumpy_stream_entity")).innerJoin("dumpy_stream")).on("( dumpy_stream.id = dumpy_stream_entity.stream_id AND dumpy_stream.job_code")).eq(new Object[]{jobCode})).literal((Object)" AND dumpy_stream.stream_code")).eq(new Object[]{streamCode})).literal((Object)") ")).where("dumpy_stream_entity.last_error_stamp")).notEq(new Object[]{null})).literal((Object)" ORDER BY dumpy_stream_entity.last_updated_stamp DESC ")).literal((Object)" OFFSET ")).param((Object)offset)).literal((Object)" LIMIT 10")).build();
        return (PaginatedResponse)new JdbcSelectOperation<PaginatedResponse>(query, rs -> {
            ArrayList result = new ArrayList();
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            PaginatedResponse cursorResponse = new PaginatedResponse();
            cursorResponse.values = result;
            cursorResponse.cursor = String.valueOf(offset + 10);
            cursorResponse.hasNext = result.size() >= 10;
            return cursorResponse;
        }).run((DataSource)this.dataSource);
    }
}

