/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.service;

import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.irenical.fetchy.service.ServiceAlreadyExistsException;
import org.irenical.fetchy.service.ServiceExecutor;
import org.irenical.fetchy.service.ServiceFactory;
import org.irenical.lifecycle.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceController
implements LifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceController.class);
    private Map<Class<?>, ServiceFactory<?>> factories;
    private Map<Class<?>, ServiceExecutor<?>> services;

    private void loadFactories() {
        for (ServiceFactory factory : ServiceLoader.load(ServiceFactory.class)) {
            try {
                this.register(factory);
            }
            catch (ServiceAlreadyExistsException e) {
                LOG.error("Error registering service, ignoring", (Throwable)e);
            }
        }
    }

    public synchronized <SERVICE> void register(ServiceFactory<SERVICE> factory) throws ServiceAlreadyExistsException {
        if (factory == null) {
            LOG.error("Trying to register null service factory, ignoring", (Throwable)new Exception());
            return;
        }
        if (factory.getServiceInterface() == null) {
            LOG.error("Service factory <" + factory + "> must declare implementing service interface, ignoring", (Throwable)new Exception());
            return;
        }
        ServiceFactory<SERVICE> was = this.factories.putIfAbsent(factory.getServiceInterface(), factory);
        if (was != null) {
            throw new ServiceAlreadyExistsException("Error loading service factory " + factory + ". A factory for service class " + factory.getServiceInterface() + " is already registered (" + was + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SERVICE> Optional<ServiceExecutor<SERVICE>> find(Class<SERVICE> serviceClass) {
        ServiceFactory<?> factory;
        ServiceExecutor<?> serviceExecutor = this.services.get(serviceClass);
        if (serviceExecutor == null && (factory = this.factories.get(serviceClass)) != null) {
            ServiceFactory<?> serviceFactory = factory;
            synchronized (serviceFactory) {
                serviceExecutor = this.services.get(serviceClass);
                if (serviceExecutor == null) {
                    serviceExecutor = factory.createService();
                    serviceExecutor.start();
                    this.services.put(serviceClass, serviceExecutor);
                }
            }
        }
        return Optional.ofNullable(serviceExecutor);
    }

    public synchronized void start() {
        this.factories = new ConcurrentHashMap();
        this.services = new ConcurrentHashMap();
        this.loadFactories();
    }

    public synchronized void stop() {
        this.services.values().stream().forEach(LifeCycle::stop);
        this.services = null;
    }

    public boolean isRunning() {
        return this.factories != null;
    }
}

