/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.service.factory;

import java.util.Optional;
import org.irenical.fetchy.node.ServiceDiscoveryController;
import org.irenical.fetchy.node.ServiceNode;
import org.irenical.fetchy.node.balancer.ServiceNodeBalancer;
import org.irenical.fetchy.node.discovery.ServiceNodeDiscovery;
import org.irenical.fetchy.service.ServiceExecutor;

public abstract class ServiceDiscoveryExecutor<IFACE, CLIENT>
implements ServiceExecutor<IFACE> {
    private final ServiceDiscoveryController serviceDiscoveryController = new ServiceDiscoveryController();
    private final String serviceId;

    public ServiceDiscoveryExecutor(String serviceId) {
        this.serviceId = serviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <OUTPUT> OUTPUT execute(ServiceExecutor.ServiceCall<IFACE, OUTPUT> callable) throws Exception {
        CLIENT clientInstance = null;
        try {
            clientInstance = this.create();
            this.onBeforeExecute(clientInstance);
            OUTPUT OUTPUT = callable.call(clientInstance);
            return OUTPUT;
        }
        finally {
            this.onAfterExecute(clientInstance);
        }
    }

    private CLIENT create() throws Exception {
        Optional<ServiceNode> serviceNode = this.serviceDiscoveryController.get(this.serviceId);
        ServiceNode node = serviceNode.orElseThrow(() -> new RuntimeException("Unable to find a service node"));
        return this.newInstance(node);
    }

    protected abstract CLIENT newInstance(ServiceNode var1) throws Exception;

    protected abstract void onBeforeExecute(CLIENT var1) throws Exception;

    protected abstract void onAfterExecute(CLIENT var1);

    public void start() throws Exception {
        this.serviceDiscoveryController.start();
    }

    public void stop() throws Exception {
        this.serviceDiscoveryController.stop();
    }

    public boolean isRunning() throws Exception {
        return this.serviceDiscoveryController.isRunning();
    }

    public void setServiceNodeDiscovery(ServiceNodeDiscovery serviceNodeLocator) {
        this.serviceDiscoveryController.setServiceNodeDiscovery(serviceNodeLocator);
    }

    public void setServiceNodeBalancer(ServiceNodeBalancer serviceNodeBalancer) {
        this.serviceDiscoveryController.setNodeBalancer(serviceNodeBalancer);
    }
}

