/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.node;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.irenical.fetchy.node.ServiceNode;
import org.irenical.fetchy.node.balancer.ServiceNodeBalancer;
import org.irenical.fetchy.node.discovery.ServiceNodeDiscovery;
import org.irenical.lifecycle.LifeCycle;

public class ServiceDiscoveryController
implements LifeCycle {
    private ServiceNodeDiscovery serviceNodeDiscovery;
    private ServiceNodeBalancer nodeBalancer;

    public void setServiceNodeDiscovery(ServiceNodeDiscovery serviceNodeDiscovery) {
        this.serviceNodeDiscovery = serviceNodeDiscovery;
    }

    public void setNodeBalancer(ServiceNodeBalancer nodeBalancer) {
        this.nodeBalancer = nodeBalancer;
    }

    public void start() throws Exception {
        this.loadServiceDiscovery();
        this.loadServiceBalancer();
    }

    public void stop() throws Exception {
        if (this.serviceNodeDiscovery != null) {
            this.serviceNodeDiscovery.stop();
            this.serviceNodeDiscovery = null;
        }
        if (this.nodeBalancer != null) {
            this.nodeBalancer.stop();
            this.nodeBalancer = null;
        }
    }

    public boolean isRunning() throws Exception {
        return this.serviceNodeDiscovery != null && this.serviceNodeDiscovery.isRunning() && this.nodeBalancer != null && this.nodeBalancer.isRunning();
    }

    public Optional<ServiceNode> get(String serviceId) {
        List<ServiceNode> nodes = this.locate(serviceId);
        return this.choose(nodes);
    }

    private List<ServiceNode> locate(String serviceId) {
        return this.serviceNodeDiscovery == null ? null : this.serviceNodeDiscovery.getServiceNodes(serviceId, true);
    }

    private Optional<ServiceNode> choose(List<ServiceNode> nodes) {
        return this.nodeBalancer == null ? this.chooseDefault(nodes) : this.nodeBalancer.getService(nodes);
    }

    private Optional<ServiceNode> chooseDefault(List<ServiceNode> nodes) {
        return Optional.empty();
    }

    private void loadServiceDiscovery() {
        LinkedList<ServiceNodeDiscovery> locators = new LinkedList<ServiceNodeDiscovery>();
        ServiceLoader<ServiceNodeDiscovery> serviceNodeLocators = ServiceLoader.load(ServiceNodeDiscovery.class);
        for (ServiceNodeDiscovery serviceNodeLocator : serviceNodeLocators) {
            locators.add(serviceNodeLocator);
        }
        if (locators.size() > 1) {
            throw new RuntimeException("multiple node locators found - choose one.");
        }
        if (!locators.isEmpty()) {
            ServiceNodeDiscovery serviceNodeLocator = (ServiceNodeDiscovery)locators.get(0);
            serviceNodeLocator.start();
            this.setServiceNodeDiscovery(serviceNodeLocator);
        }
    }

    private void loadServiceBalancer() {
        LinkedList<ServiceNodeBalancer> balancers = new LinkedList<ServiceNodeBalancer>();
        for (ServiceNodeBalancer serviceNodeBalancer : ServiceLoader.load(ServiceNodeBalancer.class)) {
            balancers.add(serviceNodeBalancer);
        }
        if (balancers.size() > 1) {
            throw new RuntimeException("multiple node balancers found - choose one.");
        }
        if (!balancers.isEmpty()) {
            ServiceNodeBalancer serviceNodeBalancer = (ServiceNodeBalancer)balancers.get(0);
            serviceNodeBalancer.start();
            this.setNodeBalancer(serviceNodeBalancer);
        }
    }
}

