/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.service;

import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.irenical.fetchy.service.ServiceAlreadyExistsException;
import org.irenical.fetchy.service.ServiceFactory;
import org.irenical.fetchy.service.Stub;
import org.irenical.lifecycle.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fetchy
implements LifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(Fetchy.class);
    private Map<String, ServiceFactory<?>> factories;
    private Map<String, Stub<?>> services;

    private void loadFactories() {
        for (ServiceFactory factory : ServiceLoader.load(ServiceFactory.class)) {
            try {
                this.register(factory);
            }
            catch (Exception e) {
                LOG.error("Error registering service, ignoring", (Throwable)e);
            }
        }
    }

    public synchronized <SERVICE> void register(ServiceFactory<SERVICE> factory) throws ServiceAlreadyExistsException {
        if (factory == null) {
            LOG.error("Trying to register null service factory, ignoring", (Throwable)new Exception());
            return;
        }
        if (factory.getId() == null) {
            LOG.error("Service factory <" + factory + "> must declare service id, ignoring", (Throwable)new Exception());
            return;
        }
        ServiceFactory<SERVICE> was = this.factories.putIfAbsent(factory.getId(), factory);
        if (was != null) {
            throw new ServiceAlreadyExistsException("Error loading service factory " + factory + ". A factory for service " + factory.getId() + " is already registered (" + was + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SERVICE> Optional<Stub<SERVICE>> find(String serviceId) {
        ServiceFactory<?> factory;
        Stub<?> serviceExecutor = this.services.get(serviceId);
        if (serviceExecutor == null && (factory = this.factories.get(serviceId)) != null) {
            ServiceFactory<?> serviceFactory = factory;
            synchronized (serviceFactory) {
                serviceExecutor = this.services.get(serviceId);
                if (serviceExecutor == null) {
                    serviceExecutor = factory.createService();
                    serviceExecutor.start();
                    this.services.put(serviceId, serviceExecutor);
                }
            }
        }
        return Optional.ofNullable(serviceExecutor);
    }

    public synchronized void start() {
        this.factories = new ConcurrentHashMap();
        this.services = new ConcurrentHashMap();
        this.loadFactories();
    }

    public synchronized void stop() {
        this.services.values().forEach(LifeCycle::stop);
        this.services = null;
    }

    public boolean isRunning() {
        return this.factories != null;
    }
}

