/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.service.factory;

import java.util.List;
import java.util.Optional;
import org.irenical.fetchy.node.ServiceNode;
import org.irenical.fetchy.node.balancer.ServiceNodeBalancer;
import org.irenical.fetchy.node.discovery.ServiceNodeDiscovery;
import org.irenical.fetchy.service.Stub;

public abstract class ServiceDiscoveryExecutor<IFACE, CLIENT extends IFACE>
implements Stub<IFACE> {
    private final String serviceId;
    private ServiceNodeDiscovery nodeDiscovery;
    private ServiceNodeBalancer nodeBalancer;

    public ServiceDiscoveryExecutor(String serviceId) {
        this.serviceId = serviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <OUTPUT, ERROR extends Exception> OUTPUT call(Stub.ServiceCall<IFACE, OUTPUT, ERROR> callable) throws ERROR {
        CLIENT clientInstance = null;
        try {
            clientInstance = this.create();
            if (clientInstance == null) {
                throw new RuntimeException("Unable to instantiate a new client");
            }
            this.onBeforeExecute(clientInstance);
            OUTPUT OUTPUT = callable.call(clientInstance);
            return OUTPUT;
        }
        finally {
            this.onAfterExecute(clientInstance);
        }
    }

    @Override
    public <ERROR extends Exception> void run(Stub.ServiceRun<IFACE, ERROR> callable) throws ERROR {
        CLIENT clientInstance = null;
        try {
            clientInstance = this.create();
            if (clientInstance == null) {
                throw new RuntimeException("Unable to instantiate a new client");
            }
            this.onBeforeExecute(clientInstance);
            callable.run(clientInstance);
        }
        finally {
            this.onAfterExecute(clientInstance);
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public boolean isRunning() throws Exception {
        return this.nodeDiscovery != null && this.nodeDiscovery.isRunning() && this.nodeBalancer != null && this.nodeBalancer.isRunning();
    }

    public void setServiceNodeDiscovery(ServiceNodeDiscovery nodeDiscovery) {
        this.nodeDiscovery = nodeDiscovery;
    }

    public void setServiceNodeBalancer(ServiceNodeBalancer nodeBalancer) {
        this.nodeBalancer = nodeBalancer;
    }

    private <ERROR extends Exception> CLIENT create() throws ERROR {
        Optional<ServiceNode> serviceNode = this.findServiceNode(this.serviceId);
        ServiceNode node = serviceNode.orElseThrow(() -> new RuntimeException("Unable to find a service node"));
        return this.newInstance(node);
    }

    protected abstract <ERROR extends Exception> CLIENT newInstance(ServiceNode var1) throws ERROR;

    protected abstract void onBeforeExecute(CLIENT var1);

    protected abstract void onAfterExecute(CLIENT var1);

    private Optional<ServiceNode> findServiceNode(String serviceId) {
        List<ServiceNode> nodes = this.locate(serviceId);
        return this.choose(nodes);
    }

    private List<ServiceNode> locate(String serviceId) {
        return this.nodeDiscovery == null ? null : this.nodeDiscovery.getServiceNodes(serviceId, true);
    }

    private Optional<ServiceNode> choose(List<ServiceNode> nodes) {
        return this.nodeBalancer == null ? this.chooseDefault(nodes) : this.nodeBalancer.getService(nodes);
    }

    private Optional<ServiceNode> chooseDefault(List<ServiceNode> nodes) {
        return nodes == null || nodes.isEmpty() ? Optional.empty() : Optional.of(nodes.get(0));
    }
}

