/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.engine;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.irenical.fetchy.Node;
import org.irenical.fetchy.balancer.Balancer;
import org.irenical.fetchy.connector.Connector;
import org.irenical.fetchy.connector.ConnectorMissingException;
import org.irenical.fetchy.connector.Stub;
import org.irenical.fetchy.discoverer.Discoverer;
import org.irenical.fetchy.event.EventEmitter;
import org.irenical.fetchy.event.FetchyEvent;
import org.irenical.fetchy.request.CallServiceDetails;
import org.irenical.fetchy.request.ImmutableRequest;
import org.irenical.fetchy.request.RequestAbortException;
import org.irenical.fetchy.request.RequestTimeoutException;
import org.irenical.lifecycle.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchyEngine
implements LifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(FetchyEngine.class);
    static final String EVENT_DISCOVER = "discover";
    static final String EVENT_BALANCE = "balance";
    static final String EVENT_CONNECT = "connect";
    static final String EVENT_REQUEST = "request";
    static final String EVENT_ERROR = "error";
    private final EventEmitter emitter;
    private ExecutorService executorService;

    public FetchyEngine() {
        this(new EventEmitter());
    }

    public FetchyEngine(ExecutorService executorService) {
        this();
        this.executorService = executorService;
    }

    FetchyEngine(EventEmitter emitter) {
        this.emitter = emitter;
    }

    public <ERROR extends Exception> void start() throws ERROR {
    }

    public <ERROR extends Exception> void stop() throws ERROR {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
        this.emitter.stop();
    }

    public <ERROR extends Exception> boolean isRunning() throws ERROR {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <OUTPUT, API, ERROR extends Exception> OUTPUT request(ImmutableRequest<OUTPUT, API, ERROR> request) throws ERROR {
        long start = System.nanoTime();
        Node node = null;
        Object result = null;
        Throwable error = null;
        CallServiceDetails<API> service = request.getServiceDetails();
        String serviceId = service.getServiceId();
        String name = request.getName();
        Integer timeoutMillis = request.getTimeoutMillis();
        try {
            node = this.attemptDiscover(name, service, start);
            Stub api = this.connect(service, node);
            this.emitter.fire(EVENT_CONNECT, name, serviceId, node, api.get(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            Callable callable = request.getCallable(api.get());
            if (timeoutMillis != null && timeoutMillis > 0) {
                Future<Object> future = this.getExecutorService().submit(() -> this.doRequest(api, callable));
                result = future.get(timeoutMillis.intValue(), TimeUnit.MILLISECONDS);
            } else {
                result = this.doRequest(api, callable);
            }
            this.emitter.fire(EVENT_REQUEST, name, serviceId, node, null, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        }
        catch (Exception e) {
            boolean raise = true;
            error = this.determineError(e);
            Callable<OUTPUT> fallback = request.getCallableFallback(error);
            if (fallback != null) {
                try {
                    result = fallback.call();
                    raise = false;
                }
                catch (Exception fallbackError) {
                    LOG.error("Error attempting to run fallback method on request '{}', service '{}'", new Object[]{name, serviceId, fallbackError});
                }
            }
            if (raise) {
                this.throwError(error);
            }
        }
        finally {
            if (error != null) {
                this.emitter.fire(EVENT_ERROR, name, serviceId, node, error, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            }
        }
        return (OUTPUT)result;
    }

    private <API> Node attemptDiscover(String name, CallServiceDetails<API> service, long start) {
        String serviceId = service.getServiceId();
        Discoverer disco = service.getDiscoverer();
        if (disco != null) {
            List<Node> nodes = disco.discover(serviceId);
            this.emitter.fire(EVENT_DISCOVER, name, serviceId, null, nodes, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            Balancer bal = service.getBalancer();
            if (bal != null) {
                Node node = bal.balance(nodes);
                this.emitter.fire(EVENT_BALANCE, name, serviceId, node, node, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                return node;
            }
            if (nodes != null && !nodes.isEmpty()) {
                return nodes.get(0);
            }
        }
        return null;
    }

    private <API> Stub<API> connect(CallServiceDetails<API> serviceDetails, Node node) {
        LOG.debug("Connecting service {} to node at {}", (Object)serviceDetails.getServiceId(), (Object)node);
        Connector<API> connector = serviceDetails.getConnector();
        if (connector == null) {
            throw new ConnectorMissingException("No connector registered for service " + serviceDetails.getServiceId());
        }
        return connector.connect(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <OUTPUT, API> OUTPUT doRequest(Stub<API> api, Callable<OUTPUT> callable) throws Exception {
        api.onBeforeExecute();
        try {
            OUTPUT OUTPUT = callable.call();
            return OUTPUT;
        }
        finally {
            api.onAfterExecute();
        }
    }

    private Throwable determineError(Exception e) {
        Throwable error = e instanceof ExecutionException ? e.getCause() : (e instanceof TimeoutException ? new RequestTimeoutException("Timeout on service run", e) : (e instanceof InterruptedException || e instanceof CancellationException ? new RequestAbortException("Error on service run", e) : e));
        return error;
    }

    private <ERROR extends Exception> void throwError(Throwable error) throws ERROR {
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        throw (Exception)error;
    }

    synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newCachedThreadPool();
        }
        return this.executorService;
    }

    public String onDiscover(Consumer<FetchyEvent<List<Node>>> listener) {
        return this.emitter.addListener(EVENT_DISCOVER, listener);
    }

    public String onBalance(Consumer<FetchyEvent<Node>> listener) {
        return this.emitter.addListener(EVENT_BALANCE, listener);
    }

    public <API> String onConnect(Consumer<FetchyEvent<API>> listener) {
        return this.emitter.addListener(EVENT_CONNECT, listener);
    }

    public String onRequest(Consumer<FetchyEvent<?>> listener) {
        return this.emitter.addListener(EVENT_REQUEST, listener);
    }

    public String onError(Consumer<FetchyEvent<Throwable>> listener) {
        return this.emitter.addListener(EVENT_ERROR, listener);
    }

    public void removeListener(String listenerId) {
        if (listenerId == null || listenerId.trim().isEmpty()) {
            throw new IllegalArgumentException("Listener ID cannot be null or empty");
        }
        this.emitter.removeListener(listenerId);
    }
}

