/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.request;

import java.util.concurrent.Callable;
import org.irenical.fetchy.engine.FetchyEngine;
import org.irenical.fetchy.request.Call;
import org.irenical.fetchy.request.CallFallback;
import org.irenical.fetchy.request.CallServiceDetails;
import org.irenical.fetchy.request.CallableRequest;
import org.irenical.fetchy.request.ImmutableRequest;

public class ImmutableCallableRequest<OUTPUT, API, ERROR extends Exception>
extends ImmutableRequest<OUTPUT, API, ERROR>
implements CallableRequest<OUTPUT, ERROR> {
    private Call<OUTPUT, API, ERROR> callable;
    private CallFallback<OUTPUT> fallback;

    public ImmutableCallableRequest(String name, FetchyEngine engine, CallServiceDetails<API> service, Integer timeoutMillis, Call<OUTPUT, API, ERROR> callable, CallFallback<OUTPUT> fallback) {
        super(name, engine, service, timeoutMillis);
        this.callable = callable;
        this.fallback = fallback;
    }

    @Override
    public OUTPUT execute() throws ERROR {
        return this.request();
    }

    @Override
    public Callable<OUTPUT> getCallable(API api) {
        return () -> this.callable.call(api);
    }

    @Override
    public Callable<OUTPUT> getCallableFallback(Throwable error) {
        return this.fallback == null ? null : () -> this.fallback.fallback(error);
    }
}

