/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.request;

import org.irenical.fetchy.engine.FetchyEngine;
import org.irenical.fetchy.request.ImmutableRunnableRequest;
import org.irenical.fetchy.request.RequestServiceDetails;
import org.irenical.fetchy.request.Run;
import org.irenical.fetchy.request.RunFallback;
import org.irenical.fetchy.request.RunnableRequest;

public class RunnableRequestBuilder<API, ERROR extends Exception> {
    private final FetchyEngine engine;
    private final RequestServiceDetails<API> serviceDetails;
    private final String name;
    private Integer timeoutMillis;
    private Run<API, ?> runnable;
    private RunFallback fallback;

    public RunnableRequestBuilder(FetchyEngine engine, RequestServiceDetails<API> serviceDetails, String name) {
        this.engine = engine;
        this.serviceDetails = serviceDetails;
        this.name = name;
    }

    public RunnableRequestBuilder<API, ERROR> timeout(Integer timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public RunnableRequestBuilder<API, ERROR> runnable(Run<API, ERROR> lambda) {
        this.runnable = lambda;
        return this;
    }

    public RunnableRequestBuilder<API, RuntimeException> fallback(RunFallback fallback) {
        RunnableRequestBuilder<API, ERROR> result = new RunnableRequestBuilder<API, ERROR>(this.engine, this.serviceDetails, this.name);
        result.timeoutMillis = this.timeoutMillis;
        result.runnable = this.runnable;
        result.fallback = fallback;
        return result;
    }

    public RunnableRequest<ERROR> build() {
        return new ImmutableRunnableRequest(this.name, this.engine, this.serviceDetails, this.timeoutMillis, this.runnable, this.fallback);
    }
}

