/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.irenical.fetchy.Node;
import org.irenical.fetchy.balancer.Balancer;
import org.irenical.fetchy.connector.Connector;
import org.irenical.fetchy.discoverer.Discoverer;
import org.irenical.fetchy.engine.FetchyEngine;
import org.irenical.fetchy.event.FetchyEvent;
import org.irenical.fetchy.request.Call;
import org.irenical.fetchy.request.RequestBuilder;
import org.irenical.fetchy.request.RequestServiceDetails;
import org.irenical.fetchy.request.Run;
import org.irenical.lifecycle.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fetchy
implements LifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(Fetchy.class);
    private final Map<String, Discoverer> discos = new ConcurrentHashMap<String, Discoverer>();
    private final Map<String, Balancer> bals = new ConcurrentHashMap<String, Balancer>();
    private final Map<String, Connector<?>> cons = new ConcurrentHashMap();
    private FetchyEngine engine;

    public Fetchy() {
        this.engine = new FetchyEngine();
    }

    public Fetchy(ExecutorService executorService) {
        this.engine = new FetchyEngine(executorService);
    }

    public void start() {
        LOG.info("Booting up Fetchy");
        this.engine.start();
        LOG.info("Fetchy boot up complete");
    }

    public void stop() {
        LOG.info("Shutting down Fetchy");
        this.engine.stop();
        LOG.info("Fetchy shutdown complete");
    }

    public <ERROR extends Exception> boolean isRunning() throws ERROR {
        return this.engine.isRunning();
    }

    public void registerDiscoverer(String serviceId, Discoverer discoverer) {
        LOG.debug("Registering discoverer {} on service {}", (Object)discoverer, (Object)serviceId);
        if (serviceId == null) {
            throw new IllegalArgumentException("Service ID cannot be null");
        }
        this.discos.put(serviceId, discoverer);
    }

    public void registerBalancer(String serviceId, Balancer balancer) {
        LOG.debug("Registering balancer {} on service {}", (Object)balancer, (Object)serviceId);
        if (serviceId == null) {
            throw new IllegalArgumentException("Service ID cannot be null");
        }
        this.bals.put(serviceId, balancer);
    }

    public void registerConnector(String serviceId, Connector<?> connector) {
        LOG.debug("Registering connector {} on service {}", connector, (Object)serviceId);
        if (serviceId == null) {
            throw new IllegalArgumentException("Service ID cannot be null");
        }
        if (connector == null) {
            throw new IllegalArgumentException("Service Connector cannot be null");
        }
        this.cons.put(serviceId, connector);
    }

    public void register(String serviceId, Discoverer discoverer, Balancer balancer, Connector<?> connector) {
        this.registerDiscoverer(serviceId, discoverer);
        this.registerBalancer(serviceId, balancer);
        this.registerConnector(serviceId, connector);
    }

    public Discoverer getServiceDiscoverer(String serviceId) {
        return this.discos.get(serviceId);
    }

    public Balancer getServiceBalancer(String serviceId) {
        return this.bals.get(serviceId);
    }

    public <API> Connector<API> getServiceConnector(String serviceId) {
        return this.cons.get(serviceId);
    }

    public String onDiscover(Consumer<FetchyEvent<List<Node>>> listener) {
        return this.engine.onDiscover(listener);
    }

    public String onBalance(Consumer<FetchyEvent<Node>> listener) {
        return this.engine.onBalance(listener);
    }

    public <API> String onConnect(Consumer<FetchyEvent<API>> listener) {
        return this.engine.onConnect(listener);
    }

    public String onRequest(Consumer<FetchyEvent<?>> listener) {
        return this.engine.onRequest(listener);
    }

    public String onError(Consumer<FetchyEvent<Throwable>> listener) {
        return this.engine.onError(listener);
    }

    public void removeListener(String listenerId) {
        this.engine.removeListener(listenerId);
    }

    public <OUTPUT, API, ERROR extends Exception> OUTPUT call(String serviceId, Class<API> apiClass, Call<OUTPUT, API, ERROR> call) throws ERROR {
        return this.call(serviceId, null, apiClass, call);
    }

    public <OUTPUT, API, ERROR extends Exception> OUTPUT call(String serviceId, String requestName, Class<API> apiClass, Call<OUTPUT, API, ERROR> call) throws ERROR {
        RequestBuilder<API> rb = this.createRequest(serviceId, requestName, apiClass);
        return rb.callable(call).build().execute();
    }

    public <API, ERROR extends Exception> void run(String serviceId, Class<API> apiClass, Run<API, ERROR> run) throws ERROR {
        this.run(serviceId, null, apiClass, run);
    }

    public <API, ERROR extends Exception> void run(String serviceId, String requestName, Class<API> apiClass, Run<API, ERROR> run) throws ERROR {
        RequestBuilder<API> rb = this.createRequest(serviceId, requestName, apiClass);
        rb.runnable(run).build().execute();
    }

    public <API> RequestBuilder<API> createRequest(String serviceId, Class<API> apiClass) {
        return this.createRequest(serviceId, null, apiClass);
    }

    public <API> RequestBuilder<API> createRequest(String serviceId, String requestName, Class<API> apiClass) {
        return new RequestBuilder<API>(this.engine, this.resolve(serviceId, apiClass), requestName == null ? "request@" + serviceId : requestName);
    }

    private <API> RequestServiceDetails<API> resolve(String serviceId, Class<API> apiClass) {
        return new RequestServiceDetails<API>(serviceId, this.getServiceConnector(serviceId), this.getServiceBalancer(serviceId), this.getServiceDiscoverer(serviceId));
    }
}

