/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.event;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.irenical.fetchy.Node;
import org.irenical.fetchy.event.FetchyEvent;
import org.irenical.lifecycle.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEmitter
implements LifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(EventEmitter.class);
    private final Map<String, Map<String, Consumer<FetchyEvent>>> listeners = new ConcurrentHashMap<String, Map<String, Consumer<FetchyEvent>>>();
    private final AtomicInteger idGenerator = new AtomicInteger(0);
    private ExecutorService executorService;

    public EventEmitter() {
    }

    public EventEmitter(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void fire(String entity, String name, String serviceId, Node node, Object target, long elapsedMillis) {
        if (!this.listeners.containsKey(entity)) {
            LOG.debug("No listeners registered for entity {}", (Object)entity);
            return;
        }
        this.getExecutorService().execute(() -> {
            FetchyEvent<Object> event = new FetchyEvent<Object>(serviceId, name, node, elapsedMillis, target);
            this.listeners.get(entity).entrySet().forEach(entry -> {
                try {
                    Consumer consumer = (Consumer)entry.getValue();
                    consumer.accept(event);
                }
                catch (RuntimeException ex) {
                    LOG.error("Error calling listener " + entry.getKey() + "... ignoring", (Throwable)ex);
                }
            });
        });
    }

    public String addListener(String entity, Consumer listener) {
        LOG.debug("Registering {} listener {}", (Object)entity, (Object)listener);
        if (entity == null || entity.trim().isEmpty()) {
            throw new IllegalArgumentException("Entity cannot be null or empty");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Map entityListeners = this.listeners.computeIfAbsent(entity, s -> new ConcurrentHashMap());
        String id = this.buildListenerId(entity);
        entityListeners.put(id, listener);
        return id;
    }

    public void removeListener(String listenerId) {
        if (listenerId == null || listenerId.trim().isEmpty()) {
            throw new IllegalArgumentException("Listener ID cannot be null or empty");
        }
        String entity = this.getEntity(listenerId);
        if (this.listeners.containsKey(entity)) {
            this.listeners.get(entity).remove(listenerId);
        }
    }

    public void clear() {
        this.listeners.clear();
        this.idGenerator.set(0);
    }

    public int getListenerCount() {
        return this.listeners.entrySet().stream().map(entry -> ((Map)entry.getValue()).size()).reduce(0, (a, b) -> a + b);
    }

    public int getListenerCount(String entity) {
        if (this.listeners.containsKey(entity)) {
            return this.listeners.get(entity).size();
        }
        return 0;
    }

    public <ERROR extends Exception> void start() throws ERROR {
    }

    public <ERROR extends Exception> void stop() throws ERROR {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    public <ERROR extends Exception> boolean isRunning() throws ERROR {
        return true;
    }

    private String getEntity(String listenerId) {
        return listenerId.substring(0, listenerId.lastIndexOf(45));
    }

    private String buildListenerId(String entity) {
        return String.format("%s-listener:%d", entity, this.idGenerator.incrementAndGet());
    }

    private synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newCachedThreadPool();
        }
        return this.executorService;
    }
}

