/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.request;

import org.irenical.fetchy.engine.FetchyEngine;
import org.irenical.fetchy.request.Call;
import org.irenical.fetchy.request.CallFallback;
import org.irenical.fetchy.request.CallableRequest;
import org.irenical.fetchy.request.ImmutableCallableRequest;
import org.irenical.fetchy.request.RequestServiceDetails;

public class CallableRequestBuilder<OUTPUT, API, ERROR extends Exception> {
    private final FetchyEngine engine;
    private RequestServiceDetails<API> serviceDetails;
    private String name;
    private Integer timeoutMillis;
    private Call<OUTPUT, API, ?> callable;
    private CallFallback<OUTPUT> fallback;

    public CallableRequestBuilder(FetchyEngine engine, RequestServiceDetails<API> serviceDetails) {
        this.engine = engine;
        this.serviceDetails = serviceDetails;
    }

    public CallableRequestBuilder<OUTPUT, API, ERROR> timeout(Integer timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public CallableRequestBuilder<OUTPUT, API, ERROR> name(String name) {
        this.name = name;
        return this;
    }

    public CallableRequestBuilder<OUTPUT, API, ERROR> callable(Call<OUTPUT, API, ERROR> lambda) {
        this.callable = lambda;
        return this;
    }

    public CallableRequestBuilder<OUTPUT, API, RuntimeException> fallback(CallFallback<OUTPUT> fallback) {
        CallableRequestBuilder<OUTPUT, API, ERROR> result = new CallableRequestBuilder<OUTPUT, API, ERROR>(this.engine, this.serviceDetails);
        result.name = this.name;
        result.timeoutMillis = this.timeoutMillis;
        result.callable = this.callable;
        result.fallback = fallback;
        return result;
    }

    public CallableRequest<OUTPUT, ERROR> build() {
        return new ImmutableCallableRequest(this.name, this.engine, this.serviceDetails, this.timeoutMillis, this.callable, this.fallback);
    }
}

