/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.request;

import java.util.concurrent.Callable;
import org.irenical.fetchy.engine.FetchyEngine;
import org.irenical.fetchy.request.ImmutableRequest;
import org.irenical.fetchy.request.RequestServiceDetails;
import org.irenical.fetchy.request.Run;
import org.irenical.fetchy.request.RunFallback;
import org.irenical.fetchy.request.RunnableRequest;

public class ImmutableRunnableRequest<API, ERROR extends Exception>
extends ImmutableRequest<Void, API, ERROR>
implements RunnableRequest<ERROR> {
    private Run<API, ?> runnable;
    private RunFallback fallback;

    public ImmutableRunnableRequest(String name, FetchyEngine engine, RequestServiceDetails<API> service, Integer timeoutMillis, Run<API, ?> runnable, RunFallback fallback) {
        super(name, engine, service, timeoutMillis);
        this.runnable = runnable;
        this.fallback = fallback;
    }

    @Override
    public void execute() throws ERROR {
        this.request();
    }

    @Override
    public Callable<Void> getCallable(API api) {
        return () -> {
            this.runnable.run(api);
            return null;
        };
    }

    @Override
    public Callable<Void> getCallableFallback(Throwable error) {
        return this.fallback == null ? null : () -> {
            this.fallback.fallback(error);
            return null;
        };
    }
}

