/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.connector.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.AbstractStub;
import java.util.function.Function;
import org.irenical.fetchy.Node;
import org.irenical.fetchy.connector.ConnectException;
import org.irenical.fetchy.connector.Connector;
import org.irenical.fetchy.connector.Stub;

public class GrpcConnector<IFACE extends AbstractStub<?>>
implements Connector<IFACE> {
    private Function<Channel, IFACE> stubGenerator;
    private boolean usePlaintext = false;

    public GrpcConnector(Function<Channel, IFACE> stubGenerator) {
        this(stubGenerator, false);
    }

    public GrpcConnector(Function<Channel, IFACE> stubGenerator, boolean usePlaintext) {
        this.stubGenerator = stubGenerator;
        this.usePlaintext = usePlaintext;
    }

    public Stub<IFACE> connect(Node node) throws ConnectException {
        final ManagedChannel channel = ManagedChannelBuilder.forAddress((String)node.getAddress(), (int)node.getPort()).usePlaintext(this.usePlaintext).build();
        final AbstractStub client = (AbstractStub)this.stubGenerator.apply((Channel)channel);
        return new Stub<IFACE>(){

            public IFACE get() {
                return client;
            }

            public void onAfterExecute() {
                channel.shutdown();
            }
        };
    }
}

