/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.connector.jersey2;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.irenical.fetchy.Node;
import org.irenical.fetchy.connector.ConnectException;
import org.irenical.fetchy.connector.Connector;
import org.irenical.fetchy.connector.Stub;
import org.irenical.lifecycle.LifeCycle;

public class Jersey2Connector
implements Connector<WebTarget>,
LifeCycle {
    private Client client;
    private boolean isRunning = false;

    public Stub<WebTarget> connect(Node node) throws ConnectException {
        if (this.client == null) {
            this.client = ((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).build();
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)node.getAddress());
        if (node.getPort() != null) {
            uriBuilder = uriBuilder.port(node.getPort().intValue());
        }
        WebTarget target = this.client.target(uriBuilder.build(new Object[0]));
        return () -> target;
    }

    public <ERROR extends Exception> void start() throws ERROR {
        this.isRunning = true;
    }

    public <ERROR extends Exception> void stop() throws ERROR {
        this.disposeClient();
        this.isRunning = false;
    }

    public <ERROR extends Exception> boolean isRunning() throws ERROR {
        return this.isRunning;
    }

    private void disposeClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }
}

