/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.connector.retrofit;

import okhttp3.OkHttpClient;
import org.irenical.fetchy.Node;
import org.irenical.fetchy.connector.ConnectException;
import org.irenical.fetchy.connector.Connector;
import org.irenical.fetchy.connector.Stub;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class RetrofitConnector<IFACE>
implements Connector<IFACE> {
    private final Class<IFACE> ifaceClass;
    private OkHttpClient httpClient;

    public RetrofitConnector(Class<IFACE> ifaceClass) {
        this.ifaceClass = ifaceClass;
    }

    public RetrofitConnector(Class<IFACE> ifaceClass, OkHttpClient httpClient) {
        this.ifaceClass = ifaceClass;
        this.httpClient = httpClient;
    }

    public Stub<IFACE> connect(Node node) throws ConnectException {
        if (this.httpClient == null) {
            this.httpClient = new OkHttpClient();
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(node.getAddress()).client(this.httpClient).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).build();
        return () -> retrofit.create(this.ifaceClass);
    }

    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

