/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.connector.soap;

import java.net.URI;
import javax.xml.ws.Service;
import org.irenical.fetchy.Node;
import org.irenical.fetchy.connector.ConnectException;
import org.irenical.fetchy.connector.Connector;
import org.irenical.fetchy.connector.Stub;
import org.irenical.fetchy.connector.soap.ServiceClient;
import org.irenical.fetchy.connector.soap.filter.ServiceClientFilter;

public class SOAPConnector<ENDPOINT extends Service, PORT>
implements Connector<PORT> {
    private final Class<ENDPOINT> endpointClass;
    private final Class<PORT> portClass;
    private final ServiceClientFilter[] filters;
    private String address;
    private PORT port;

    public SOAPConnector(Class<ENDPOINT> endpointClass, Class<PORT> portClass) {
        this(endpointClass, portClass, null);
    }

    public SOAPConnector(Class<ENDPOINT> endpointClass, Class<PORT> portClass, ServiceClientFilter[] filters) {
        this.endpointClass = endpointClass;
        this.portClass = portClass;
        this.filters = filters;
    }

    public Stub<PORT> connect(Node node) throws ConnectException {
        if (this.address == null || !node.getAddress().equals(this.address) || this.port == null) {
            this.address = node.getAddress();
            ServiceClient<ENDPOINT, PORT> serviceClient = new ServiceClient<ENDPOINT, PORT>(this.endpointClass, this.portClass, URI.create(node.getAddress()), this.filters);
            this.port = serviceClient.getPort();
        }
        return () -> this.port;
    }
}

