/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.connector.soap;

import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import org.irenical.fetchy.connector.soap.filter.ServiceClientFilter;
import org.irenical.fetchy.connector.soap.filter.ServiceClientPortFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceClient<ENDPOINT extends Service, PORT> {
    private final Logger LOG = LoggerFactory.getLogger(ServiceClient.class);
    private final Class<ENDPOINT> endpointClass;
    private final Class<PORT> portClass;
    private final URI serviceUrl;
    private final List<WebServiceFeature> webServiceFeatureList = new LinkedList<WebServiceFeature>();
    private final List<ServiceClientFilter> serviceClientFilters;
    private ENDPOINT endpointSOAPService;
    private List<Handler> handlers = new LinkedList<Handler>();
    private HandlerResolver handlerResolver = paramPortInfo -> this.handlers;

    ServiceClient(Class<ENDPOINT> endpointClass, Class<PORT> portClass, URI serviceUrl) {
        this(endpointClass, portClass, serviceUrl, null);
    }

    ServiceClient(Class<ENDPOINT> endpointClass, Class<PORT> portClass, URI serviceUrl, ServiceClientFilter[] filters) {
        Objects.requireNonNull(endpointClass);
        Objects.requireNonNull(portClass);
        Objects.requireNonNull(serviceUrl);
        this.endpointClass = endpointClass;
        this.portClass = portClass;
        this.serviceUrl = serviceUrl;
        this.serviceClientFilters = filters == null ? Collections.emptyList() : Arrays.asList(filters);
        this.initEndpoint();
    }

    private void initEndpoint() {
        try {
            URL url = this.serviceUrl.toURL();
            this.endpointSOAPService = (Service)this.endpointClass.getConstructor(URL.class).newInstance(url);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating a new instance of SOAP endpoint: " + this.endpointClass.getName() + " for url: " + this.serviceUrl, e);
        }
        for (ServiceClientFilter filter : this.serviceClientFilters) {
            filter.init(this);
            this.LOG.info("Loaded service client filter " + filter.getClass().getName());
        }
        if (!this.handlers.isEmpty()) {
            this.setSOAPHandlers();
        }
    }

    private void setSOAPHandlers() {
        this.endpointSOAPService.setHandlerResolver(this.handlerResolver);
    }

    public void addSOAPHandler(Handler handler) {
        this.handlers.add(handler);
        this.setSOAPHandlers();
    }

    public void addSOAPFeature(WebServiceFeature feature) {
        this.webServiceFeatureList.add(feature);
    }

    PORT getPort() {
        return this.getPort(null);
    }

    PORT getPort(ServiceClientPortFilter[] portFilters) {
        Object port = this.endpointSOAPService.getPort(this.portClass, this.webServiceFeatureList.toArray(new WebServiceFeature[this.webServiceFeatureList.size()]));
        for (ServiceClientFilter filter : this.serviceClientFilters) {
            filter.postGetPort(this, port);
        }
        if (portFilters != null) {
            for (ServiceClientPortFilter portFilter : portFilters) {
                portFilter.postGetPort(port);
            }
        }
        return (PORT)port;
    }
}

