/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.connector.thrift;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.irenical.fetchy.Node;
import org.irenical.fetchy.connector.ConnectException;
import org.irenical.fetchy.connector.Connector;
import org.irenical.fetchy.connector.Stub;

public class ThriftConnector<IFACE, CLIENT extends IFACE>
implements Connector<CLIENT> {
    private final Class<CLIENT> clientType;

    public ThriftConnector(Class<CLIENT> clientType) {
        this.clientType = clientType;
    }

    public Stub<CLIENT> connect(Node node) throws ConnectException {
        try {
            TFramedTransport tTransport = new TFramedTransport((TTransport)new TSocket(node.getAddress(), node.getPort().intValue()));
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)tTransport);
            Constructor<CLIENT> constructor = this.clientType.getConstructor(TProtocol.class);
            final CLIENT client = constructor.newInstance(protocol);
            return new Stub<CLIENT>(){

                public CLIENT get() {
                    return client;
                }

                public void onBeforeExecute() {
                    try {
                        ThriftConnector.this.open(client);
                    }
                    catch (TTransportException e) {
                        throw new ConnectException(e.getLocalizedMessage(), (Throwable)e);
                    }
                }

                public void onAfterExecute() {
                    ThriftConnector.this.close(client);
                }
            };
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConnectException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void open(CLIENT clientInstance) throws TTransportException {
        if (clientInstance != null) {
            this.open(((TServiceClient)clientInstance).getInputProtocol());
            this.open(((TServiceClient)clientInstance).getOutputProtocol());
        }
    }

    private void close(CLIENT clientInstance) {
        if (clientInstance != null) {
            this.close(((TServiceClient)clientInstance).getInputProtocol());
            this.close(((TServiceClient)clientInstance).getOutputProtocol());
        }
    }

    private void open(TProtocol protocol) throws TTransportException {
        TTransport transport;
        if (protocol != null && (transport = protocol.getTransport()) != null && !transport.isOpen()) {
            transport.open();
        }
    }

    private void close(TProtocol protocol) {
        TTransport transport;
        if (protocol != null && (transport = protocol.getTransport()) != null && transport.isOpen()) {
            transport.close();
        }
    }
}

