/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.node.discovery.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.irenical.fetchy.node.ServiceNode;
import org.irenical.fetchy.node.discovery.ServiceNodeDiscovery;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigFactory;

public class ConsulNodeDiscovery
implements ServiceNodeDiscovery {
    private static final String DEFAULT_CONSUL_HOST_PROPERTY = "consul.host";
    private static final String DEFAULT_CONSUL_PORT_PROPERTY = "consul.port";
    private static final int DEFAULT_CONSUL_PORT = 8500;
    private final Config config = ConfigFactory.getConfig();
    private final String consulHostPropertyKey;
    private final String consulPortPropertyKey;
    private ConsulClient consulClient;

    public ConsulNodeDiscovery() {
        this(DEFAULT_CONSUL_HOST_PROPERTY, DEFAULT_CONSUL_PORT_PROPERTY);
    }

    public ConsulNodeDiscovery(String consulHostPropertyKey) {
        this(consulHostPropertyKey, DEFAULT_CONSUL_PORT_PROPERTY);
    }

    public ConsulNodeDiscovery(String consulHostPropertyKey, String consulPortPropertyKey) {
        if (consulHostPropertyKey == null || consulHostPropertyKey.trim().isEmpty()) {
            throw new IllegalArgumentException("consul host property key cannot be null or empty");
        }
        if (consulPortPropertyKey == null || consulPortPropertyKey.trim().isEmpty()) {
            throw new IllegalArgumentException("consul port property key cannot be null or empty");
        }
        this.consulHostPropertyKey = consulHostPropertyKey;
        this.consulPortPropertyKey = consulPortPropertyKey;
    }

    public void start() throws Exception {
        this.consulClient = new ConsulClient(this.config.getMandatoryString(this.consulHostPropertyKey), this.config.getInt(this.consulPortPropertyKey, 8500));
    }

    public void stop() throws Exception {
        this.consulClient = null;
    }

    public boolean isRunning() throws Exception {
        if (this.consulClient == null) {
            return false;
        }
        Response agentSelf = this.consulClient.getAgentSelf();
        return agentSelf != null && agentSelf.getValue() != null;
    }

    public List<ServiceNode> getServiceNodes(String serviceId, boolean onlyHealthy) {
        Response serviceResponse = this.consulClient.getHealthServices(serviceId, onlyHealthy, null);
        if (serviceResponse == null) {
            return new ArrayList<ServiceNode>(0);
        }
        List responseValue = (List)serviceResponse.getValue();
        if (responseValue == null) {
            return new ArrayList<ServiceNode>(0);
        }
        return responseValue.stream().map(this::fromHealthService).collect(Collectors.toList());
    }

    private ServiceNode fromHealthService(HealthService healthService) {
        HealthService.Service consulService = healthService.getService();
        HealthService.Node consulNode = healthService.getNode();
        Integer port = consulService.getPort();
        ServiceNode serviceNode = new ServiceNode();
        serviceNode.setAddress(ConsulNodeDiscovery.coalesce(consulService.getAddress(), consulNode.getAddress()));
        serviceNode.setPort(port == null || port == 0 ? null : port);
        serviceNode.setNode(consulNode.getNode());
        serviceNode.setStatus(this.getServiceStatus(healthService, consulService.getId()));
        return serviceNode;
    }

    private ServiceNode.ServiceStatus getServiceStatus(HealthService healthService, String serviceId) {
        List checks = healthService.getChecks();
        return checks.stream().filter(check -> ("service:" + serviceId).equals(check.getCheckId())).map(check -> {
            switch (check.getStatus()) {
                case CRITICAL: {
                    return ServiceNode.ServiceStatus.CRITICAL;
                }
                case PASSING: {
                    return ServiceNode.ServiceStatus.HEALTHY;
                }
                case WARNING: {
                    return ServiceNode.ServiceStatus.WARNING;
                }
            }
            return ServiceNode.ServiceStatus.UNKNOWN;
        }).collect(Collectors.collectingAndThen(Collectors.toList(), new Function<List<ServiceNode.ServiceStatus>, ServiceNode.ServiceStatus>(){

            @Override
            public ServiceNode.ServiceStatus apply(List<ServiceNode.ServiceStatus> list) {
                if (list == null || list.isEmpty()) {
                    return ServiceNode.ServiceStatus.UNKNOWN;
                }
                return list.get(0);
            }
        }));
    }

    private static String coalesce(String ... parameters) {
        for (String parameter : parameters) {
            if (parameter == null || parameter.trim().isEmpty()) continue;
            return parameter;
        }
        return null;
    }
}

