/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.executor.jersey2;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.irenical.fetchy.node.ServiceNode;
import org.irenical.fetchy.service.factory.ServiceDiscoveryExecutor;

public class Jersey2ServiceExecutor
extends ServiceDiscoveryExecutor<WebTarget, WebTarget> {
    private Client client;
    private String address;

    public Jersey2ServiceExecutor(String serviceId) {
        super(serviceId);
    }

    protected WebTarget newInstance(ServiceNode serviceNode) throws Exception {
        if (this.address == null || !serviceNode.getAddress().equals(this.address)) {
            this.address = serviceNode.getAddress();
            this.disposeClient();
        }
        if (this.client == null) {
            this.client = ((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).build();
        }
        return this.client.target(serviceNode.getAddress());
    }

    protected void onBeforeExecute(WebTarget iface) {
    }

    protected void onAfterExecute(WebTarget iface) {
    }

    public void stop() throws Exception {
        super.stop();
        this.disposeClient();
    }

    private void disposeClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }
}

