/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.executor.retrofit;

import okhttp3.OkHttpClient;
import org.irenical.fetchy.node.ServiceNode;
import org.irenical.fetchy.service.factory.ServiceDiscoveryExecutor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class RetrofitServiceExecutor<IFACE>
extends ServiceDiscoveryExecutor<IFACE, IFACE> {
    private final Class<IFACE> ifaceClass;
    private OkHttpClient httpClient;

    public RetrofitServiceExecutor(Class<IFACE> ifaceClass, String serviceId) {
        super(serviceId);
        this.ifaceClass = ifaceClass;
    }

    protected IFACE newInstance(ServiceNode serviceNode) throws Exception {
        Retrofit.Builder builder = new Retrofit.Builder().baseUrl(serviceNode.getAddress());
        if (this.httpClient != null) {
            builder.client(this.httpClient);
        }
        builder.addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create());
        builder.addConverterFactory((Converter.Factory)MoshiConverterFactory.create());
        Retrofit retrofit = builder.build();
        return (IFACE)retrofit.create(this.ifaceClass);
    }

    protected void onBeforeExecute(IFACE iface) {
    }

    protected void onAfterExecute(IFACE iface) {
    }

    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

