/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.service.factory.thrift;

import org.irenical.fetchy.node.balancer.ServiceNodeBalancer;
import org.irenical.fetchy.node.discovery.ServiceNodeDiscovery;
import org.irenical.fetchy.service.Stub;
import org.irenical.fetchy.service.factory.ServiceDiscoveryFactory;
import org.irenical.fetchy.service.factory.thrift.ThriftServiceExecutor;

public class ThriftServiceDiscoveryFactory<IFACE, CLIENT extends IFACE>
extends ServiceDiscoveryFactory<IFACE> {
    private final Class<CLIENT> clientClass;
    private final String serviceId;

    public ThriftServiceDiscoveryFactory(Class<IFACE> serviceInterface, Class<CLIENT> clientClass, String serviceId) {
        super(serviceInterface);
        this.clientClass = clientClass;
        this.serviceId = serviceId;
    }

    public Stub<IFACE> createService() {
        ServiceNodeBalancer serviceNodeBalancer;
        ThriftServiceExecutor serviceExecutor = new ThriftServiceExecutor(this.clientClass, this.serviceId);
        ServiceNodeDiscovery serviceNodeLocator = this.getServiceNodeDiscovery();
        if (serviceNodeLocator != null) {
            serviceExecutor.setServiceNodeDiscovery(serviceNodeLocator);
        }
        if ((serviceNodeBalancer = this.getServiceNodeBalancer()) != null) {
            serviceExecutor.setServiceNodeBalancer(serviceNodeBalancer);
        }
        return serviceExecutor;
    }
}

