/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.service.factory.thrift;

import java.lang.reflect.Constructor;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.irenical.fetchy.node.ServiceNode;
import org.irenical.fetchy.service.factory.ServiceDiscoveryExecutor;

public class ThriftServiceExecutor<IFACE, CLIENT extends IFACE>
extends ServiceDiscoveryExecutor<IFACE, CLIENT> {
    private final Class<CLIENT> clientType;

    public ThriftServiceExecutor(Class<CLIENT> clientType, String serviceId) {
        super(serviceId);
        this.clientType = clientType;
    }

    protected CLIENT newInstance(ServiceNode serviceNode) throws Exception {
        TFramedTransport tTransport = new TFramedTransport((TTransport)new TSocket(serviceNode.getAddress(), serviceNode.getPort().intValue()));
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)tTransport);
        Constructor<CLIENT> constructor = this.clientType.getConstructor(TProtocol.class);
        return constructor.newInstance(protocol);
    }

    protected void onBeforeExecute(CLIENT client) {
        try {
            this.open(client);
        }
        catch (TTransportException e) {
            throw new RuntimeException(e);
        }
    }

    protected void onAfterExecute(CLIENT client) {
        this.close(client);
    }

    private void open(CLIENT clientInstance) throws TTransportException {
        if (clientInstance != null) {
            this.open(((TServiceClient)clientInstance).getInputProtocol());
            this.open(((TServiceClient)clientInstance).getOutputProtocol());
        }
    }

    private void close(CLIENT clientInstance) {
        if (clientInstance != null) {
            this.close(((TServiceClient)clientInstance).getInputProtocol());
            this.close(((TServiceClient)clientInstance).getOutputProtocol());
        }
    }

    private void open(TProtocol protocol) throws TTransportException {
        TTransport transport;
        if (protocol != null && (transport = protocol.getTransport()) != null && !transport.isOpen()) {
            transport.open();
        }
    }

    private void close(TProtocol protocol) {
        TTransport transport;
        if (protocol != null && (transport = protocol.getTransport()) != null && transport.isOpen()) {
            transport.close();
        }
    }
}

