/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.jindy.commons;

import org.apache.commons.configuration.Configuration;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigContext;
import org.irenical.jindy.ConfigNotFoundException;
import org.irenical.jindy.PropertyChangedCallback;

public class CommonsWrapper
implements Config,
ConfigContext {
    private final Configuration config;

    public CommonsWrapper(Configuration config) {
        this.config = config;
    }

    private void assertKey(String key) throws ConfigNotFoundException {
        if (!this.config.containsKey(key)) {
            throw new ConfigNotFoundException("Mandatory configuration property '" + key + "' was not found");
        }
    }

    public void unListen(String listenerId) {
    }

    public String listen(String key, Config.Match keyMatchingRule, PropertyChangedCallback callback) {
        return null;
    }

    public String listen(String key, PropertyChangedCallback callback) {
        return null;
    }

    public String[] getStringArray(String key) {
        return this.config.getStringArray(key);
    }

    public String getString(String key, String defaultValue) {
        return this.config.getString(key, defaultValue);
    }

    public String getString(String key) {
        return this.config.getString(key);
    }

    public String getMandatoryString(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return this.config.getString(key);
    }

    public int getMandatoryInt(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return this.config.getInt(key);
    }

    public float getMandatoryFloat(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return this.config.getFloat(key);
    }

    public boolean getMandatoryBoolean(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return this.config.getBoolean(key);
    }

    public long getMandatoryLong(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return this.config.getLong(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.config.getInt(key, defaultValue);
    }

    public float getFloat(String key, float defaultValue) {
        return this.config.getFloat(key, defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return this.config.getLong(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.config.getBoolean(key, defaultValue);
    }

    public void setProperty(String key, Object value) {
        this.config.setProperty(key, value);
    }

    public Iterable<String> getKeys(String keyPrefix) {
        return () -> keyPrefix == null ? this.config.getKeys() : this.config.getKeys(keyPrefix);
    }

    public Config filterPrefix(String prefix) {
        return new CommonsWrapper(this.config.subset(prefix));
    }

    public void clearProperty(String key) {
        this.config.clearProperty(key);
    }

    public void clear() {
        this.config.clear();
    }

    public String getApplicationId() {
        return this.config.getString("application");
    }

    public String getDatacenter() {
        return this.config.getString("datacenter");
    }

    public String getEnvironment() {
        return this.config.getString("environment");
    }

    public String getRegion() {
        return this.config.getString("region");
    }

    public String getServerId() {
        return this.config.getString("serverId");
    }

    public String getStack() {
        return this.config.getString("stack");
    }
}

