/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.jindy;

import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigBindingNotFoundException;
import org.irenical.jindy.ConfigMultipleBindingsException;
import org.irenical.jindy.IConfigFactory;
import org.irenical.jindy.InvalidConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFactory {
    public static String DEFAULT_CONFIG_NAME;
    private static Logger LOG;
    private static Map<String, Config> configs;

    private static synchronized void init() {
        if (configs == null) {
            DEFAULT_CONFIG_NAME = "DEFAULT";
            configs = new ConcurrentHashMap<String, Config>();
            LOG = LoggerFactory.getLogger(ConfigFactory.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config getConfig(String name, IConfigFactory factory) {
        Config got;
        if (configs == null) {
            ConfigFactory.init();
        }
        if (name == null) {
            name = DEFAULT_CONFIG_NAME;
        }
        if ((got = configs.get(name)) == null) {
            LOG.debug("No Config instance named " + name + "... requesting a new one");
            String string = name.intern();
            synchronized (string) {
                got = configs.get(name);
                if (got == null) {
                    Config config = got = factory == null ? ConfigFactory.load(name) : factory.createConfig(name);
                    if (got == null) {
                        LOG.error("Factory " + factory + " returned a null Config");
                        throw new InvalidConfigException("Invalid Config returned by " + factory + " factory: null");
                    }
                    configs.put(name, got);
                }
            }
        }
        return got;
    }

    private static Config load(String name) {
        LOG.info("Looking for a IConfigFactory implementation");
        ServiceLoader<IConfigFactory> loader = ServiceLoader.load(IConfigFactory.class);
        Iterator<IConfigFactory> implIterator = loader.iterator();
        IConfigFactory got = null;
        if (implIterator.hasNext()) {
            got = implIterator.next();
        }
        if (implIterator.hasNext()) {
            StringBuilder sb = new StringBuilder("Multiple bindings found on classpath for " + IConfigFactory.class.getName() + "[");
            boolean first = true;
            for (IConfigFactory current : loader) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(current.getClass().getName());
                first = false;
            }
            sb.append("]");
            LOG.error(sb.toString());
            throw new ConfigMultipleBindingsException(sb.toString());
        }
        if (got != null) {
            LOG.info("Found a IConfigFactory implementation: " + got.getClass().getName());
            return got.createConfig(name);
        }
        LOG.error("No bindings found. Make sure you have an implementation class declared in META-INF/services/" + IConfigFactory.class.getName());
        throw new ConfigBindingNotFoundException("No bindings found. Make sure you have an implementation class declared in META-INF/services/" + IConfigFactory.class.getName());
    }

    public static Config getConfig(String name) {
        return ConfigFactory.getConfig(name, null);
    }

    public static Config getConfig() {
        return ConfigFactory.getConfig(null);
    }

    public static void clear() {
        if (configs != null) {
            configs.clear();
        }
    }
}

