/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.jindy;

import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigBindingNotFoundException;
import org.irenical.jindy.ConfigContext;
import org.irenical.jindy.ConfigMultipleBindingsException;
import org.irenical.jindy.IConfigFactory;
import org.irenical.jindy.InvalidConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFactory {
    public static String DEFAULT_CONFIG_NAME;
    private static Logger LOG;
    private static Map<String, Config> configs;
    private static IConfigFactory defaultConfigFactory;
    private static volatile ConfigContext context;

    private static synchronized void init() {
        if (configs == null) {
            DEFAULT_CONFIG_NAME = "DEFAULT";
            configs = new ConcurrentHashMap<String, Config>();
            LOG = LoggerFactory.getLogger(ConfigFactory.class);
        }
    }

    private static void log(boolean debug, String message, Exception error) {
        if (LOG != null) {
            if (error != null) {
                LOG.error(message, (Throwable)error);
            } else if (debug) {
                LOG.debug(message);
            } else {
                LOG.info(message);
            }
        }
    }

    public static Config getConfig() {
        return ConfigFactory.getConfig(null);
    }

    public static Config getConfig(String name) {
        return ConfigFactory.getConfig(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config getConfig(String name, IConfigFactory factory) {
        Config got;
        if (configs == null) {
            ConfigFactory.init();
        }
        if (name == null) {
            name = DEFAULT_CONFIG_NAME;
        }
        if ((got = configs.get(name)) == null) {
            ConfigFactory.log(true, "No Config instance named " + name + "... requesting a new one", null);
            String string = name.intern();
            synchronized (string) {
                got = configs.get(name);
                if (got == null) {
                    Config config = got = factory == null ? ConfigFactory.load(name) : factory.createConfig(name);
                    if (got == null) {
                        ConfigFactory.log(false, "Factory " + factory + " returned a null Config", null);
                        throw new InvalidConfigException("Invalid Config returned by " + factory + " factory: null");
                    }
                    configs.put(name, got);
                }
            }
        }
        return got;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Config load(String name) {
        ConfigFactory.log(false, "Looking for a IConfigFactory implementation", null);
        ServiceLoader<IConfigFactory> loader = ServiceLoader.load(IConfigFactory.class);
        Iterator<IConfigFactory> implIterator = loader.iterator();
        IConfigFactory got = null;
        if (implIterator.hasNext()) {
            got = implIterator.next();
        }
        if (implIterator.hasNext()) {
            StringBuilder sb = new StringBuilder("Multiple bindings found on classpath for " + IConfigFactory.class.getName() + "[");
            boolean first = true;
            for (IConfigFactory current : loader) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(current.getClass().getName());
                first = false;
            }
            sb.append("]");
            ConfigFactory.log(false, sb.toString(), null);
            throw new ConfigMultipleBindingsException(sb.toString());
        }
        if (got != null) {
            ConfigFactory.log(false, "Found a IConfigFactory implementation: " + got.getClass().getName(), null);
            return got.createConfig(name);
        }
        Class<ConfigFactory> clazz = ConfigFactory.class;
        synchronized (ConfigFactory.class) {
            if (defaultConfigFactory != null) {
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return defaultConfigFactory.createConfig(name);
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            ConfigFactory.log(false, "No bindings found. Make sure you have an implementation class declared in META-INF/services/" + IConfigFactory.class.getName(), null);
            throw new ConfigBindingNotFoundException("No bindings found. Make sure you have an implementation class declared in META-INF/services/" + IConfigFactory.class.getName());
        }
    }

    public static void setContext(ConfigContext context) {
        ConfigFactory.context = context;
    }

    public static ConfigContext getContext() {
        return context;
    }

    public static synchronized void setDefaultConfigFactory(IConfigFactory factory) {
        defaultConfigFactory = factory;
    }

    public static synchronized void clear() {
        if (configs != null) {
            configs.clear();
        }
        defaultConfigFactory = null;
        context = null;
    }
}

