/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.jindy.archaius;

import com.netflix.config.ConfigurationManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigChangedCallback;
import org.irenical.jindy.ConfigNotFoundException;

public class ArchaiusWrapper
implements Config {
    private final Map<String, List<ConfigChangedCallback>> callbacks = new ConcurrentHashMap<String, List<ConfigChangedCallback>>();

    public void listen(String key, ConfigChangedCallback callback) {
        List<ConfigChangedCallback> forKey = this.callbacks.get(key);
        if (forKey == null && null != this.callbacks.putIfAbsent(key, forKey = new CopyOnWriteArrayList<ConfigChangedCallback>())) {
            forKey = this.callbacks.get(key);
        }
        forKey.add(callback);
    }

    public void unListen(ConfigChangedCallback callback) {
        for (String key : new LinkedList<String>(this.callbacks.keySet())) {
            this.unListen(key, callback);
        }
    }

    protected void fire(String key) {
        List<ConfigChangedCallback> forKey = this.callbacks.get(key);
        if (forKey != null) {
            for (int i = 0; i < forKey.size(); ++i) {
                ConfigChangedCallback callback = forKey.get(i);
                callback.propertyChanged();
            }
        }
    }

    private void unListen(String key, ConfigChangedCallback callback) {
        List<ConfigChangedCallback> forKey = this.callbacks.get(key);
        while (forKey.remove(callback)) {
        }
    }

    private void assertKey(String key) throws ConfigNotFoundException {
        if (!ConfigurationManager.getConfigInstance().containsKey(key)) {
            throw new ConfigNotFoundException("Mandatory configuration property '" + key + "' was not found");
        }
    }

    public String[] getStringArray(String key) {
        return ConfigurationManager.getConfigInstance().getStringArray(key);
    }

    public String getString(String key, String defaultValue) {
        return ConfigurationManager.getConfigInstance().getString(key, defaultValue);
    }

    public String getString(String key) {
        return ConfigurationManager.getConfigInstance().getString(key);
    }

    public String getMandatoryString(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return ConfigurationManager.getConfigInstance().getString(key);
    }

    public int getMandatoryInt(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return ConfigurationManager.getConfigInstance().getInt(key);
    }

    public float getMandatoryFloat(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return ConfigurationManager.getConfigInstance().getFloat(key);
    }

    public boolean getMandatoryBoolean(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return ConfigurationManager.getConfigInstance().getBoolean(key);
    }

    public int getInt(String key, int defaultValue) {
        return ConfigurationManager.getConfigInstance().getInt(key, defaultValue);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return ConfigurationManager.getConfigInstance().getBoolean(key, defaultValue);
    }
}

