/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.jindy.archaius;

import com.netflix.config.ConfigurationManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigChangedCallback;
import org.irenical.jindy.ConfigNotFoundException;
import org.irenical.jindy.PropertyChangedCallback;

public class ArchaiusWrapper
implements Config {
    private final Map<String, Map<Config.Match, List<Object>>> callbacksByMatch = new ConcurrentHashMap<String, Map<Config.Match, List<Object>>>();

    private List<Object> getCallbacks(String key, Config.Match match) {
        List<Object> forKey;
        Map<Config.Match, List<Object>> allMatches;
        if (match == null) {
            match = Config.Match.EXACT;
        }
        if ((allMatches = this.callbacksByMatch.get(key)) == null && null != this.callbacksByMatch.putIfAbsent(key, allMatches = new ConcurrentHashMap<Config.Match, List<Object>>())) {
            allMatches = this.callbacksByMatch.get(key);
        }
        if ((forKey = allMatches.get(match)) == null && null != allMatches.putIfAbsent(match, forKey = new CopyOnWriteArrayList<Object>())) {
            forKey = allMatches.get(match);
        }
        return forKey;
    }

    public void listen(String key, Config.Match keyMatchingRule, PropertyChangedCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        this.getCallbacks(key, keyMatchingRule).add(callback);
    }

    public void listen(String key, PropertyChangedCallback callback) {
        this.listen(key, Config.Match.EXACT, callback);
    }

    public void listen(String key, Config.Match keyMatchingRule, ConfigChangedCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        this.getCallbacks(key, keyMatchingRule).add(callback);
    }

    public void listen(String key, ConfigChangedCallback callback) {
        this.listen(key, Config.Match.EXACT, callback);
    }

    public void unListen(ConfigChangedCallback callback) {
        for (Map map : new LinkedList<Map<Config.Match, List<Object>>>(this.callbacksByMatch.values())) {
            for (Config.Match match : new LinkedList(map.keySet())) {
                List forKey = (List)map.get(match);
                while (forKey.remove(callback)) {
                }
            }
        }
    }

    protected void fire(String key) {
        this.fireMatch(key, Config.Match.EXACT);
        this.firePrefixOrSuffix(key);
    }

    private void firePrefixOrSuffix(String key) {
        for (String k : new LinkedList<String>(this.callbacksByMatch.keySet())) {
            if (key.startsWith(k)) {
                this.fireMatch(key, Config.Match.PREFIX);
            }
            if (!key.endsWith(k)) continue;
            this.fireMatch(key, Config.Match.SUFFIX);
        }
    }

    private void fireMatch(String key, Config.Match match) {
        List<Object> callbacks = this.getCallbacks(key, match);
        if (callbacks != null) {
            for (int i = 0; i < callbacks.size(); ++i) {
                Object callback = callbacks.get(i);
                if (callback instanceof PropertyChangedCallback) {
                    ((PropertyChangedCallback)callback).propertyChanged(key);
                    continue;
                }
                if (callback instanceof ConfigChangedCallback) {
                    ((ConfigChangedCallback)callback).propertyChanged();
                    continue;
                }
                throw new RuntimeException("Unsupported callback object: " + callback);
            }
        }
    }

    private void assertKey(String key) throws ConfigNotFoundException {
        if (!ConfigurationManager.getConfigInstance().containsKey(key)) {
            throw new ConfigNotFoundException("Mandatory configuration property '" + key + "' was not found");
        }
    }

    public String[] getStringArray(String key) {
        return ConfigurationManager.getConfigInstance().getStringArray(key);
    }

    public String getString(String key, String defaultValue) {
        return ConfigurationManager.getConfigInstance().getString(key, defaultValue);
    }

    public String getString(String key) {
        return ConfigurationManager.getConfigInstance().getString(key);
    }

    public String getMandatoryString(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return ConfigurationManager.getConfigInstance().getString(key);
    }

    public int getMandatoryInt(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return ConfigurationManager.getConfigInstance().getInt(key);
    }

    public float getMandatoryFloat(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return ConfigurationManager.getConfigInstance().getFloat(key);
    }

    public boolean getMandatoryBoolean(String key) throws ConfigNotFoundException {
        this.assertKey(key);
        return ConfigurationManager.getConfigInstance().getBoolean(key);
    }

    public int getInt(String key, int defaultValue) {
        return ConfigurationManager.getConfigInstance().getInt(key, defaultValue);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return ConfigurationManager.getConfigInstance().getBoolean(key, defaultValue);
    }

    public void setProperty(String key, Object value) {
        ConfigurationManager.getConfigInstance().setProperty(key, value);
    }

    public Iterable<String> getKeys(final String keyPrefix) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return keyPrefix == null ? ConfigurationManager.getConfigInstance().getKeys() : ConfigurationManager.getConfigInstance().getKeys(keyPrefix);
            }
        };
    }
}

