/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.jindy.archaius;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.Configuration;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigChangedCallback;
import org.irenical.jindy.ConfigNotFoundException;
import org.irenical.jindy.PropertyChangedCallback;

public class ArchaiusWrapper
implements Config {
    private final Map<String, Map<Config.Match, List<Object>>> callbacksByMatch;
    private final Configuration configuration;
    private final String prefix;
    private final ArchaiusWrapper parent;

    public ArchaiusWrapper(String prefix, ArchaiusWrapper parent) {
        this.parent = parent;
        this.configuration = parent.configuration;
        this.prefix = prefix == null ? "" : prefix;
        this.callbacksByMatch = null;
    }

    public ArchaiusWrapper(Configuration configuration) {
        this.parent = null;
        this.configuration = configuration;
        this.prefix = "";
        this.callbacksByMatch = new ConcurrentHashMap<String, Map<Config.Match, List<Object>>>();
    }

    private Map<String, Map<Config.Match, List<Object>>> getAllCallbacks() {
        return this.parent != null ? this.parent.getAllCallbacks() : this.callbacksByMatch;
    }

    private List<Object> getCallbacks(String key, Config.Match match) {
        List<Object> forKey;
        Map<Config.Match, List<Object>> allMatches;
        Map<String, Map<Config.Match, List<Object>>> callbacksByMatch = this.getAllCallbacks();
        if (match == null) {
            match = Config.Match.EXACT;
        }
        if ((allMatches = callbacksByMatch.get(key)) == null && null != callbacksByMatch.putIfAbsent(key, allMatches = new ConcurrentHashMap<Config.Match, List<Object>>())) {
            allMatches = callbacksByMatch.get(key);
        }
        if ((forKey = allMatches.get(match)) == null && null != allMatches.putIfAbsent(match, forKey = new CopyOnWriteArrayList<Object>())) {
            forKey = allMatches.get(match);
        }
        return forKey;
    }

    public void listen(String key, Config.Match keyMatchingRule, PropertyChangedCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        PropertyChangedCallback prefixedCallback = null;
        if (this.parent != null) {
            prefixedCallback = k -> callback.propertyChanged(k.substring(this.prefix.length()));
        }
        this.getCallbacks(this.prefix + key, keyMatchingRule).add(prefixedCallback == null ? callback : prefixedCallback);
    }

    public void listen(String key, PropertyChangedCallback callback) {
        this.listen(key, Config.Match.EXACT, callback);
    }

    public void listen(String key, Config.Match keyMatchingRule, ConfigChangedCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        this.getCallbacks(this.prefix + key, keyMatchingRule).add(callback);
    }

    public void listen(String key, ConfigChangedCallback callback) {
        this.listen(key, Config.Match.EXACT, callback);
    }

    public void unListen(ConfigChangedCallback callback) {
        for (Map map : new LinkedList<Map<Config.Match, List<Object>>>(this.getAllCallbacks().values())) {
            for (Config.Match match : new LinkedList(map.keySet())) {
                List forKey = (List)map.get(match);
                while (forKey.remove(callback)) {
                }
            }
        }
    }

    protected void fire(String key) {
        this.fireMatch(this.prefix + key, Config.Match.EXACT);
        this.firePrefixOrSuffix(this.prefix + key);
    }

    private void firePrefixOrSuffix(String key) {
        for (String k : new LinkedList<String>(this.getAllCallbacks().keySet())) {
            if (key.startsWith(k)) {
                this.fireMatch(key, Config.Match.PREFIX);
            }
            if (!key.endsWith(k)) continue;
            this.fireMatch(key, Config.Match.SUFFIX);
        }
    }

    private void fireMatch(String key, Config.Match match) {
        List<Object> callbacks = this.getCallbacks(key, match);
        if (callbacks != null) {
            for (Object callback : callbacks) {
                if (callback instanceof PropertyChangedCallback) {
                    ((PropertyChangedCallback)callback).propertyChanged(key);
                    continue;
                }
                if (callback instanceof ConfigChangedCallback) {
                    ((ConfigChangedCallback)callback).propertyChanged();
                    continue;
                }
                throw new RuntimeException("Unsupported callback object: " + callback);
            }
        }
    }

    private void assertKey(String key) throws ConfigNotFoundException {
        if (!this.configuration.containsKey(key)) {
            throw new ConfigNotFoundException("Mandatory configuration property '" + key + "' was not found");
        }
    }

    public String[] getStringArray(String key) {
        return this.configuration.getStringArray(this.prefix + key);
    }

    public String getString(String key, String defaultValue) {
        return this.configuration.getString(this.prefix + key, defaultValue);
    }

    public String getString(String key) {
        return this.configuration.getString(this.prefix + key);
    }

    public String getMandatoryString(String key) throws ConfigNotFoundException {
        key = this.prefix + key;
        this.assertKey(key);
        return this.configuration.getString(key);
    }

    public int getMandatoryInt(String key) throws ConfigNotFoundException {
        key = this.prefix + key;
        this.assertKey(key);
        return this.configuration.getInt(key);
    }

    public float getMandatoryFloat(String key) throws ConfigNotFoundException {
        key = this.prefix + key;
        this.assertKey(key);
        return this.configuration.getFloat(key);
    }

    public boolean getMandatoryBoolean(String key) throws ConfigNotFoundException {
        key = this.prefix + key;
        this.assertKey(key);
        return this.configuration.getBoolean(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.configuration.getInt(this.prefix + key, defaultValue);
    }

    public float getFloat(String key, float defaultValue) {
        return this.configuration.getFloat(this.prefix + key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.configuration.getBoolean(this.prefix + key, defaultValue);
    }

    public void setProperty(String key, Object value) {
        this.configuration.setProperty(this.prefix + key, value);
    }

    public Iterable<String> getKeys(String keyPrefix) {
        return () -> keyPrefix == null ? (this.prefix == null ? this.configuration.getKeys() : this.configuration.getKeys(this.prefix)) : this.configuration.getKeys(this.prefix + keyPrefix);
    }

    public Config filterPrefix(String prefix) {
        return new ArchaiusWrapper(prefix == null || prefix.endsWith(".") ? prefix : prefix + ".", this);
    }

    public void clearProperty(String key) {
        this.configuration.clearProperty(key);
    }

    public void clear() {
        this.configuration.clear();
    }
}

