/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.jindy.archaius;

import com.netflix.config.ConfigurationManager;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.Configuration;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigContext;
import org.irenical.jindy.ConfigNotFoundException;
import org.irenical.jindy.PropertyChangedCallback;

public class ArchaiusWrapper
implements Config,
ConfigContext {
    private final Map<String, Map<Config.Match, Map<String, PropertyChangedCallback>>> callbacksByMatch;
    private final Configuration configuration;
    private final String prefix;
    private final ArchaiusWrapper parent;

    public ArchaiusWrapper(String prefix, ArchaiusWrapper parent) {
        this.parent = parent;
        this.configuration = parent.configuration;
        this.prefix = prefix == null ? "" : prefix;
        this.callbacksByMatch = null;
    }

    public ArchaiusWrapper(Configuration configuration) {
        this.parent = null;
        this.configuration = configuration;
        this.prefix = "";
        this.callbacksByMatch = new ConcurrentHashMap<String, Map<Config.Match, Map<String, PropertyChangedCallback>>>();
    }

    private Map<String, Map<Config.Match, Map<String, PropertyChangedCallback>>> getAllCallbacks() {
        return this.parent != null ? this.parent.getAllCallbacks() : this.callbacksByMatch;
    }

    private Map<String, PropertyChangedCallback> getCallbacks(String key, Config.Match match, boolean create) {
        Map<String, PropertyChangedCallback> forKey;
        Map<Config.Match, Map<String, PropertyChangedCallback>> allMatches;
        Map<String, Map<Config.Match, Map<String, PropertyChangedCallback>>> callbacksByMatch = this.getAllCallbacks();
        if (match == null) {
            match = Config.Match.EXACT;
        }
        if ((allMatches = callbacksByMatch.get(key)) == null) {
            if (!create) {
                return null;
            }
            allMatches = new ConcurrentHashMap<Config.Match, Map<String, PropertyChangedCallback>>();
            if (null != callbacksByMatch.putIfAbsent(key, allMatches)) {
                allMatches = callbacksByMatch.get(key);
            }
        }
        if ((forKey = allMatches.get(match)) == null) {
            if (!create) {
                return null;
            }
            forKey = new ConcurrentHashMap<String, PropertyChangedCallback>();
            if (null != allMatches.putIfAbsent(match, forKey)) {
                forKey = allMatches.get(match);
            }
        }
        return forKey;
    }

    public String listen(String key, Config.Match keyMatchingRule, PropertyChangedCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        PropertyChangedCallback prefixedCallback = null;
        if (this.parent != null) {
            prefixedCallback = k -> callback.propertyChanged(k.substring(this.prefix.length()));
        }
        String id = UUID.randomUUID().toString();
        this.getCallbacks(this.prefix + key, keyMatchingRule, true).put(id, prefixedCallback == null ? callback : prefixedCallback);
        return id;
    }

    public String listen(String key, PropertyChangedCallback callback) {
        return this.listen(key, Config.Match.EXACT, callback);
    }

    public void unListen(String listenerId) {
        for (Map map : new LinkedList<Map<Config.Match, Map<String, PropertyChangedCallback>>>(this.getAllCallbacks().values())) {
            for (Config.Match match : new LinkedList(map.keySet())) {
                Map forKey = (Map)map.get(match);
                forKey.remove(listenerId);
            }
        }
    }

    protected void fire(String key) {
        this.fireMatch(this.prefix + key, Config.Match.EXACT);
        this.firePrefixOrSuffix(this.prefix + key);
    }

    private void firePrefixOrSuffix(String key) {
        for (String k : new LinkedList<String>(this.getAllCallbacks().keySet())) {
            if (key.startsWith(k)) {
                this.fireMatch(k, Config.Match.PREFIX);
            }
            if (!key.endsWith(k)) continue;
            this.fireMatch(k, Config.Match.SUFFIX);
        }
    }

    private void fireMatch(String key, Config.Match match) {
        Map<String, PropertyChangedCallback> callbacks = this.getCallbacks(key, match, false);
        if (callbacks != null) {
            for (PropertyChangedCallback callback : callbacks.values()) {
                callback.propertyChanged(key);
            }
        }
    }

    private void assertKey(String key) throws ConfigNotFoundException {
        if (!this.configuration.containsKey(key)) {
            throw new ConfigNotFoundException("Mandatory configuration property '" + key + "' was not found");
        }
    }

    public String[] getStringArray(String key) {
        return this.configuration.getStringArray(this.prefix + key);
    }

    public String getString(String key, String defaultValue) {
        return this.configuration.getString(this.prefix + key, defaultValue);
    }

    public String getString(String key) {
        return this.configuration.getString(this.prefix + key);
    }

    public String getMandatoryString(String key) throws ConfigNotFoundException {
        key = this.prefix + key;
        this.assertKey(key);
        return this.configuration.getString(key);
    }

    public int getMandatoryInt(String key) throws ConfigNotFoundException {
        key = this.prefix + key;
        this.assertKey(key);
        return this.configuration.getInt(key);
    }

    public long getMandatoryLong(String key) throws ConfigNotFoundException {
        key = this.prefix + key;
        this.assertKey(key);
        return this.configuration.getLong(key);
    }

    public float getMandatoryFloat(String key) throws ConfigNotFoundException {
        key = this.prefix + key;
        this.assertKey(key);
        return this.configuration.getFloat(key);
    }

    public boolean getMandatoryBoolean(String key) throws ConfigNotFoundException {
        key = this.prefix + key;
        this.assertKey(key);
        return this.configuration.getBoolean(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.configuration.getInt(this.prefix + key, defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return this.configuration.getLong(this.prefix + key, defaultValue);
    }

    public float getFloat(String key, float defaultValue) {
        return this.configuration.getFloat(this.prefix + key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.configuration.getBoolean(this.prefix + key, defaultValue);
    }

    public void setProperty(String key, Object value) {
        this.configuration.setProperty(this.prefix + key, value);
    }

    public Iterable<String> getKeys(String keyPrefix) {
        return () -> keyPrefix == null ? (this.prefix == null ? this.configuration.getKeys() : this.configuration.getKeys(this.prefix)) : this.configuration.getKeys(this.prefix + keyPrefix);
    }

    public Config filterPrefix(String prefix) {
        return new ArchaiusWrapper(prefix == null || prefix.endsWith(".") ? prefix : prefix + ".", this);
    }

    public void clearProperty(String key) {
        this.configuration.clearProperty(key);
    }

    public void clear() {
        this.configuration.clear();
    }

    public String getApplicationId() {
        return ConfigurationManager.getDeploymentContext().getApplicationId();
    }

    public String getDatacenter() {
        return ConfigurationManager.getDeploymentContext().getDeploymentDatacenter();
    }

    public String getEnvironment() {
        return ConfigurationManager.getDeploymentContext().getDeploymentEnvironment();
    }

    public String getRegion() {
        return ConfigurationManager.getDeploymentContext().getDeploymentRegion();
    }

    public String getServerId() {
        return ConfigurationManager.getDeploymentContext().getDeploymentServerId();
    }

    public String getStack() {
        return ConfigurationManager.getDeploymentContext().getDeploymentStack();
    }
}

