/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.jindy.archaius;

import com.boundary.config.ConsulWatchedConfigurationSource;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.kv.KeyValueClient;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicWatchedConfiguration;
import com.netflix.config.WatchedConfigurationSource;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigFactory;
import org.irenical.jindy.archaius.ArchaiusBaseFactory;
import org.irenical.jindy.archaius.ConsulConfigStrategy;
import org.irenical.jindy.commons.CommonsWrapper;

public class ArchaiusConsulFactory
extends ArchaiusBaseFactory {
    public static final String CONSUL_HOST = "consul.host";
    public static final String CONSUL_PORT = "consul.port";
    public static final String CONSUL_TOKEN = "consul.token";
    public static final String CONSUL_DEFAULT_HOST = "consul.service.consul";

    protected DynamicWatchedConfiguration getConfiguration() {
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        String consulHost = config.getString(CONSUL_HOST, CONSUL_DEFAULT_HOST);
        int consulPort = config.getInt(CONSUL_PORT, 8500);
        String consulAclToken = config.getString(CONSUL_TOKEN);
        String rootConfigPath = null;
        ConsulConfigStrategy strategy = this.findStrategy();
        if (strategy != null) {
            rootConfigPath = strategy.getBasePath((Config)new CommonsWrapper((Configuration)config));
        } else {
            String appName = Optional.ofNullable(ConfigurationManager.getDeploymentContext().getApplicationId()).orElse(ConfigFactory.getContext() == null ? null : ConfigFactory.getContext().getApplicationId());
            if (appName == null) {
                throw new RuntimeException(DeploymentContext.ContextKey.appId.getKey() + " was not set and no app name set");
            }
            rootConfigPath = appName;
        }
        ConsulWatchedConfigurationSource configSource = new ConsulWatchedConfigurationSource(rootConfigPath, (KeyValueClient)new ConsulClient(consulHost, consulPort), 30L, TimeUnit.SECONDS, consulAclToken);
        try {
            configSource.runOnce();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        configSource.startAsync();
        return new DynamicWatchedConfiguration((WatchedConfigurationSource)configSource);
    }

    private ConsulConfigStrategy findStrategy() {
        ServiceLoader<ConsulConfigStrategy> sl = ServiceLoader.load(ConsulConfigStrategy.class);
        Iterator<ConsulConfigStrategy> iterator = sl.iterator();
        if (iterator.hasNext()) {
            ConsulConfigStrategy consulConfigStrategy = iterator.next();
            return consulConfigStrategy;
        }
        return null;
    }
}

