/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.jindy.archaius;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicConfiguration;
import com.netflix.config.DynamicWatchedConfiguration;
import com.netflix.config.WatchedConfigurationSource;
import com.netflix.config.source.EtcdConfigurationSource;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.configuration.AbstractConfiguration;
import org.boon.etcd.ClientBuilder;
import org.boon.etcd.Etcd;
import org.irenical.jindy.ConfigNotFoundException;
import org.irenical.jindy.archaius.ArchaiusBaseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchaiusEtcdFactory
extends ArchaiusBaseFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ArchaiusEtcdFactory.class);
    public static final String ETCD_HOSTS = "etcd.hosts";

    protected AbstractConfiguration getConfiguration() throws ConfigNotFoundException {
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        boolean dynamic = config.getBoolean("dynamicConfig", true);
        if (!dynamic) {
            return new DynamicConfiguration();
        }
        DeploymentContext context = ConfigurationManager.getDeploymentContext();
        String appId = context.getApplicationId();
        if (appId == null) {
            LOG.info("No applicationId set on archaius deployment context. Will try to use the 'application' property as fallback.");
            appId = config.getString("application");
        }
        if (appId == null) {
            throw new RuntimeException("Archaius deployment context's applicationId not set nor property 'application' found");
        }
        String[] etcdHosts = config.getStringArray(ETCD_HOSTS);
        if (etcdHosts == null || etcdHosts.length <= 0) {
            throw new ConfigNotFoundException("No etcd hosts configured. Could not create etcd client");
        }
        URI[] etcdHostURIs = (URI[])Arrays.stream(etcdHosts).map(URI::create).toArray(URI[]::new);
        Etcd etcdClient = ClientBuilder.builder().hosts(etcdHostURIs).createClient();
        EtcdConfigurationSource configSource = new EtcdConfigurationSource(etcdClient, appId);
        return new DynamicWatchedConfiguration((WatchedConfigurationSource)configSource);
    }
}

