/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.jindy.test;

import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigFactory;
import org.irenical.jindy.ConfigNotFoundException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JindyConfigTest {
    static final String P1 = "myprop1";
    static final String P2 = "myprop2";
    static final String V1 = "one";
    static final String V2 = "2";
    static final String P_P1 = "prefix1.myprop1";
    static final String P_P2 = "prefix2.myprop2";
    static final String P_V1 = "one-prefixed";
    static final String P_V2 = "two-prefixed";
    private static final String P3 = "prop3";
    Config config;

    @Before
    public void setupConfig() {
        this.config = ConfigFactory.getConfig();
        this.config.setProperty(P1, (Object)V1);
        this.config.setProperty(P2, (Object)V2);
        this.config.setProperty(P_P1, (Object)P_V1);
        this.config.setProperty(P_P2, (Object)P_V2);
    }

    @After
    public void clearConfig() {
        this.config.clear();
    }

    @Test
    public void testGetString() {
        Assert.assertEquals((Object)V1, (Object)this.config.getString(P1));
        Assert.assertEquals((Object)V2, (Object)this.config.getString(P2));
        Assert.assertNull((Object)this.config.getString(P3));
    }

    @Test
    public void testGetExistingMandatoryString() throws ConfigNotFoundException {
        Assert.assertEquals((Object)V1, (Object)this.config.getMandatoryString(P1));
    }

    @Test(expected=ConfigNotFoundException.class)
    public void testGetNonexistingMandatoryString() throws ConfigNotFoundException {
        this.config.getMandatoryString(P3);
    }

    @Test
    public void testInt() {
        Assert.assertEquals((long)Integer.valueOf(V2).intValue(), (long)this.config.getInt(P2, 0));
        Assert.assertNotEquals((Object)V2, (Object)this.config.getInt(P3, 0));
        Assert.assertEquals((long)0L, (long)this.config.getInt(P3, 0));
    }

    @Test
    public void testSetProperty() {
        Assert.assertNull((Object)this.config.getString("prop"));
        this.config.setProperty("prop", (Object)"erty");
        Assert.assertEquals((Object)"erty", (Object)this.config.getString("prop"));
    }

    @Test
    public void testGetPrefixedProperty() throws Exception {
        Config prefix1 = this.config.filterPrefix("prefix1");
        Assert.assertEquals((Object)P_V1, (Object)prefix1.getString(P1));
        Assert.assertNull((Object)prefix1.getString(P2));
        Config prefix2 = this.config.filterPrefix("prefix2");
        Assert.assertEquals((Object)P_V2, (Object)prefix2.getString(P2));
    }

    @Test
    public void testSetPrefixedProperty() throws Exception {
        Config prefix1 = this.config.filterPrefix("prefix1");
        Assert.assertEquals((Object)P_V1, (Object)prefix1.getString(P1));
        prefix1.setProperty(P1, (Object)"qwerty");
        Assert.assertEquals((Object)"qwerty", (Object)prefix1.getString(P1));
        Assert.assertEquals((Object)V1, (Object)this.config.getString(P1));
        Assert.assertEquals((Object)"qwerty", (Object)this.config.getString(P_P1));
    }
}

