/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.slf4j;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.spi.ContextAwareBase;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LoggerConfigurator
extends ContextAwareBase
implements Configurator {
    private static final String APPENDER_CONSOLE = "CONSOLE";
    private static final String APPENDER_FILE = "FILE";
    private static final String LEVEL = "log.level";
    private static final String CONSOLE_ENABLED = "log.console.enabled";
    private static final String CONSOLE_PATTERN = "log.console.pattern";
    private static final String FILE_ENABLED = "log.file.enabled";
    private static final String FILE_PATTERN = "log.file.pattern";
    private static final String FILE_BACKUP_DATE_PATTERN = "log.file.backupdatepattern";
    private static final String FILE_PATH = "log.file.path";
    private static final String FILE_MAXBACKUPS = "log.file.maxbackups";
    private static final String DEFAULT_PATTERN = "%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n";
    private static final String DEFAULT_FILE_PATH = "./log/";
    private static final int DEFAULT_FILE_MAXBACKUPS = 5;
    private static final String DEFAULT_BACKUP_DATE_PATERN = "%d{yyyy-MM-dd}";
    private static final String EXT = ".log";
    private static final String SEP = "-";
    private static volatile boolean started = false;
    private final Config CONFIG = ConfigFactory.getConfig();

    protected void initListeners() {
        this.CONFIG.listen(LEVEL, this::updateLevel);
        this.CONFIG.listen(CONSOLE_ENABLED, this::updateConsole);
        this.CONFIG.listen(CONSOLE_PATTERN, this::updateConsole);
        this.CONFIG.listen(FILE_ENABLED, this::updateFile);
        this.CONFIG.listen(FILE_PATTERN, this::updateFile);
        this.CONFIG.listen(FILE_MAXBACKUPS, this::updateFile);
        this.CONFIG.listen(FILE_PATH, this::updateFile);
        this.CONFIG.listen(FILE_BACKUP_DATE_PATTERN, this::updateFile);
    }

    public void configure(LoggerContext loggerContext) {
        if (!started) {
            this.initListeners();
            started = true;
        }
        loggerContext.reset();
        this.installJulBridge();
        this.updateLevel();
        this.updateConsole();
        this.updateFile();
    }

    private void installJulBridge() {
        LoggerContext loggerContext = (LoggerContext)this.getContext();
        if (!SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
        LevelChangePropagator julLevelChanger = new LevelChangePropagator();
        julLevelChanger.setContext((Context)loggerContext);
        julLevelChanger.setResetJUL(true);
        loggerContext.addListener((LoggerContextListener)julLevelChanger);
    }

    private void updateFile() {
        try {
            LoggerContext loggerContext = (LoggerContext)this.getContext();
            Logger logbackLogger = loggerContext.getLogger("ROOT");
            RollingFileAppender fileAppender = (RollingFileAppender)logbackLogger.getAppender(APPENDER_FILE);
            if (this.CONFIG.getBoolean(FILE_ENABLED, false)) {
                logbackLogger.detachAppender((Appender)fileAppender);
                fileAppender = new RollingFileAppender();
                fileAppender.setName(APPENDER_FILE);
                fileAppender.setContext((Context)loggerContext);
                String file = this.CONFIG.getString(FILE_PATH, DEFAULT_FILE_PATH);
                if (!file.endsWith("/")) {
                    file = file + "/";
                }
                fileAppender.setFile(file + this.CONFIG.getString("application") + EXT);
                TimeBasedRollingPolicy rollPolicy = new TimeBasedRollingPolicy();
                rollPolicy.setContext((Context)loggerContext);
                rollPolicy.setFileNamePattern(file + this.CONFIG.getString("application") + SEP + this.CONFIG.getString(FILE_BACKUP_DATE_PATTERN, DEFAULT_BACKUP_DATE_PATERN) + EXT);
                rollPolicy.setMaxHistory(this.CONFIG.getInt(FILE_MAXBACKUPS, 5));
                rollPolicy.setParent((FileAppender)fileAppender);
                fileAppender.setRollingPolicy((RollingPolicy)rollPolicy);
                fileAppender.setTriggeringPolicy((TriggeringPolicy)rollPolicy);
                PatternLayoutEncoder encoder = new PatternLayoutEncoder();
                encoder.setContext((Context)loggerContext);
                encoder.setPattern(this.CONFIG.getString(FILE_PATTERN, DEFAULT_PATTERN));
                fileAppender.setEncoder((Encoder)encoder);
                logbackLogger.addAppender((Appender)fileAppender);
                rollPolicy.start();
                encoder.start();
                fileAppender.start();
            } else {
                logbackLogger.detachAppender((Appender)fileAppender);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateConsole() {
        LoggerContext loggerContext = (LoggerContext)this.getContext();
        Logger logbackLogger = loggerContext.getLogger("ROOT");
        ConsoleAppender consoleAppender = (ConsoleAppender)logbackLogger.getAppender(APPENDER_CONSOLE);
        if (this.CONFIG.getBoolean(CONSOLE_ENABLED, true)) {
            logbackLogger.detachAppender((Appender)consoleAppender);
            consoleAppender = new ConsoleAppender();
            consoleAppender.setContext((Context)loggerContext);
            consoleAppender.setName(APPENDER_CONSOLE);
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)loggerContext);
            encoder.setPattern(this.CONFIG.getString(CONSOLE_PATTERN, DEFAULT_PATTERN));
            consoleAppender.setEncoder((Encoder)encoder);
            encoder.start();
            consoleAppender.start();
            logbackLogger.addAppender((Appender)consoleAppender);
        } else {
            logbackLogger.detachAppender((Appender)consoleAppender);
        }
    }

    private void updateLevel() {
        String level;
        LoggerContext loggerContext = (LoggerContext)this.getContext();
        Logger logbackLogger = loggerContext.getLogger("ROOT");
        switch (level = this.CONFIG.getString(LEVEL, "DEBUG")) {
            case "ERROR": {
                logbackLogger.setLevel(Level.ERROR);
                break;
            }
            case "WARN": {
                logbackLogger.setLevel(Level.WARN);
                break;
            }
            case "INFO": {
                logbackLogger.setLevel(Level.INFO);
                break;
            }
            case "DEBUG": {
                logbackLogger.setLevel(Level.DEBUG);
                break;
            }
            case "TRACE": {
                logbackLogger.setLevel(Level.TRACE);
                break;
            }
            case "ALL": {
                logbackLogger.setLevel(Level.ALL);
                break;
            }
            default: {
                logbackLogger.setLevel(Level.OFF);
            }
        }
    }
}

