/*
 * Decompiled with CFR 0.152.
 */
package org.iru.maven.plugins.jaxbgenser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XJBSerialVersionUIDMojo
extends AbstractMojo {
    private MavenProject project;
    private File bindingDirectory;
    private String globalBindings;
    private Namespace JAXB_NAMESPACE = new Namespace("jaxb", "http://java.sun.com/xml/ns/jaxb");

    static String extractMajorAndMinor(String version) {
        Pattern versionPattern = Pattern.compile("^((\\d+)(\\.\\d+)?)\\.?.*");
        Matcher m = versionPattern.matcher(version);
        if (m.matches()) {
            return m.group(1);
        }
        return version;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            StringBuilder sb = new StringBuilder(this.project.getGroupId());
            sb.append(":").append(this.project.getArtifactId());
            sb.append(":").append(XJBSerialVersionUIDMojo.extractMajorAndMinor(this.project.getVersion()));
            sb.append(":").append(this.project.getPackaging());
            md.update(sb.toString().getBytes("UTF-8"));
            byte[] b = md.digest();
            long l = 0L;
            for (int i = 0; i < 8; ++i) {
                if (i != 0) {
                    l <<= 8;
                }
                l += (long)b[i];
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Using " + sb + " to generate serialVersionUID: " + l));
            }
            DocumentFactory docf = new DocumentFactory();
            Document doc = docf.createDocument();
            Element root = docf.createElement(new QName("bindings", this.JAXB_NAMESPACE));
            root.addAttribute(new QName("version", this.JAXB_NAMESPACE), "2.1");
            doc.setRootElement(root);
            Element gb = docf.createElement(new QName("globalBindings", this.JAXB_NAMESPACE));
            root.add(gb);
            Element serializable = docf.createElement(new QName("serializable", this.JAXB_NAMESPACE));
            serializable.addAttribute("uid", Long.toString(l));
            gb.add(serializable);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setIndentSize(4);
            this.bindingDirectory.mkdirs();
            int i = this.globalBindings.lastIndexOf(46);
            String prefix = i == -1 ? this.globalBindings : this.globalBindings.substring(0, i);
            String suffix = i == -1 || i == this.globalBindings.length() - 1 ? "tmp" : this.globalBindings.substring(i + 1);
            File tmp = FileUtils.createTempFile((String)prefix, (String)suffix, (File)this.bindingDirectory);
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(tmp), format);
            writer.write(doc);
            writer.close();
            File xjb = new File(this.bindingDirectory, this.globalBindings);
            if (FileUtils.contentEquals((File)xjb, (File)tmp)) {
                tmp.delete();
            } else {
                xjb.delete();
                tmp.renameTo(xjb);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

