/**
 * 
 */
package org.isuper.common.utils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Super Wang
 *
 */
public class CookieUtils {

	public static String getCookieValue(String name, HttpServletRequest request) {
		Cookie[] cookies = request.getCookies();
		if (cookies != null) {
			for (Cookie cookie : cookies) {
				if (cookie != null && cookie.getName().equals(name)) {
					return cookie.getValue();
				}
			}
		}
		return null;
	}

	public static void putCookie(String name, String value, int expiration, HttpServletRequest request, HttpServletResponse response) {
		if (value == null) {
			removeCookie(name, request, response);
		} else {
			Cookie c = new Cookie(name, value);
			c.setMaxAge(expiration);
			c.setPath(request.getContextPath());
			response.addCookie(c);
		}
	}

	public static void removeCookie(String name, HttpServletRequest request, HttpServletResponse response) {
		Cookie c = new Cookie(name, "");
		c.setMaxAge(0);
		c.setPath(request.getContextPath());
		response.addCookie(c);
	}

}
