/**
 * 
 */
package org.isuper.common.utils;

/**
 * @author Super Wang
 *
 */
public final class Preconditions {

	private static final String DEFAULT_MESSAGE = "Received an invalid parameter";

	/**
	 * Checks that an object is not null.
	 * 
	 * @param object
	 *            any object
	 * @param errorMsg
	 *            error message
	 * 
	 * @throws IllegalArgumentException
	 *             if the object is null
	 */
	public static void notNull(Object object, String errorMsg) {
		check(object != null, errorMsg);
	}

	/**
	 * Checks that a string is not null or empty
	 * 
	 * @param string
	 *            any string
	 * @param errorMsg
	 *            error message
	 * 
	 * @throws IllegalArgumentException
	 *             if the string is null or empty
	 */
	public static void notEmptyString(String string, String errorMsg) {
		check(!isEmptyString(string), errorMsg);
	}
	
	/**
	 * @param string
	 * @return
	 */
	public static boolean isEmptyString(String string) {
		return string == null || "".equals(string.trim());
	}

	private static void check(boolean requirements, String error) {
		String message = (isEmptyString(error)) ? DEFAULT_MESSAGE : error;
		if (!requirements) {
			throw new IllegalArgumentException(message);
		}
	}

}
