/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.common.utils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtils {
    public static String getCookieValue(String key, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !cookie.getName().equals(key)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static void putCookie(String key, String value, int expiration, HttpServletRequest request, HttpServletResponse response) {
        if (value == null) {
            CookieUtils.removeCookie(key, request, response);
        } else {
            Cookie c = new Cookie(key, value);
            c.setMaxAge(expiration);
            c.setPath(request.getContextPath());
            response.addCookie(c);
        }
    }

    public static void removeCookie(String key, HttpServletRequest request, HttpServletResponse response) {
        Cookie c = new Cookie(key, "");
        c.setMaxAge(0);
        c.setPath(request.getContextPath());
        response.addCookie(c);
    }
}

