/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.common.utils;

public final class Preconditions {
    private static final String DEFAULT_MESSAGE = "Received an invalid parameter";

    public static void notNull(Object object, String errorMsg) {
        Preconditions.matchRequirement(object != null, errorMsg);
    }

    public static void notEmptyString(String string, String errorMsg) {
        Preconditions.matchRequirement(!Preconditions.isEmptyString(string), errorMsg);
    }

    public static boolean isEmptyString(String string) {
        return string == null || string.isEmpty();
    }

    private static void matchRequirement(boolean requirements, String errorMsg) {
        String message;
        String string = message = Preconditions.isEmptyString(errorMsg) ? DEFAULT_MESSAGE : errorMsg;
        if (!requirements) {
            throw new IllegalArgumentException(message);
        }
    }
}

